/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.shell;

import com.urbancode.shell.CommandLineArg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLine {
    private List<CommandLineArg> list = new ArrayList<CommandLineArg>();

    public CommandLine() {
    }

    public CommandLine(String executable) {
        this.addArgument(executable);
    }

    public CommandLine(String ... args) {
        this.addArguments(args);
    }

    public CommandLine(List<String> args) {
        this.addArguments(args);
    }

    public void addArgument(CommandLineArg arg) {
        this.list.add(arg);
    }

    public void addArgument(String arg) {
        this.addArgument(new CommandLineArg(arg));
    }

    public void addArgument(String arg, boolean secured) {
        this.addArgument(new CommandLineArg(arg, secured));
    }

    public void addArgument(String arg, String value) {
        this.addArgument(arg);
        this.addArgument(value);
    }

    public void addArgument(String arg, String value, boolean secured) {
        this.addArgument(arg);
        this.addArgument(value, secured);
    }

    public void addArguments(String ... args) {
        for (String arg : args) {
            this.addArgument(new CommandLineArg(arg));
        }
    }

    public void addArguments(List<String> args) {
        for (String arg : args) {
            this.addArgument(new CommandLineArg(arg));
        }
    }

    public CommandLineArg[] getArgArray() {
        CommandLineArg[] result = new CommandLineArg[this.list.size()];
        this.list.toArray(result);
        return result;
    }

    public String[] toStringArray() {
        String[] result = new String[this.list.size()];
        for (int i = 0; i < this.list.size(); ++i) {
            CommandLineArg arg = this.list.get(i);
            result[i] = arg.getValue();
        }
        return result;
    }

    public List<String> toList() {
        return Arrays.asList(this.toStringArray());
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.list.size(); ++i) {
            CommandLineArg arg = this.list.get(i);
            result.append(arg.toString());
            if (i >= this.list.size()) continue;
            result.append(" ");
        }
        return result.toString().trim();
    }
}

