/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.shell;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.concurrent.WaitFuture;
import com.urbancode.commons.util.processes.Processes;
import com.urbancode.shell.Shell;
import com.urbancode.shell.ShellException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;

class Util {
    static final boolean windows;
    static final boolean vms;
    static final boolean os9;
    static final boolean unix;
    static final boolean zos;
    static final boolean ibmi;
    static final File PLUGIN_HOME;
    static final File AGENT_HOME;
    private static File tempDir;
    static boolean tempDirDetected;
    private static final String lineSep;
    private static final Processes processes;

    static void chmod(File file) throws IOException, InterruptedException, ExecutionException {
        ProcessBuilder bp = new ProcessBuilder("chmod", "+x", file.getAbsolutePath());
        Process chmod = bp.start();
        chmod.getOutputStream().close();
        Util.redirectOutAndErrAndWait(chmod);
    }

    static List<String> createCommandLine(String interpreter, File scriptFile) {
        ArrayList<String> commandLine = new ArrayList<String>();
        if (Util.truthy(interpreter)) {
            if (windows) {
                commandLine.add("cmd");
                commandLine.add("/C");
                commandLine.add(interpreter);
            } else {
                commandLine.addAll(Util.tokenize(interpreter));
            }
        }
        commandLine.add(scriptFile.getAbsolutePath());
        return commandLine;
    }

    static String createVmsScriptBody(File workDir, String scriptBody) {
        List<String> path = Util.tokenize(workDir.getPath(), "/\\");
        String buf = Util.first(path) + ":";
        List<String> directories = Util.tail(path);
        if (Util.truthy(directories)) {
            buf = buf + "[" + String.join((CharSequence)".", directories) + "]";
        }
        return "$ SET DEFAULT " + buf + "\n$ " + scriptBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int executeShellCommand(File workDir, boolean daemon, List<String> commandLine, File outputFile, String blockSeparator) throws IOException, ShellException, InterruptedException, ExecutionException {
        Shell shell = new Shell(commandLine);
        shell.setWorkingDirectory(workDir);
        shell.setDaemon(daemon);
        shell.setOutputFile(outputFile);
        if (daemon) {
            String message = "running as daemon: output ";
            message = outputFile != null ? message + "redirected to " + outputFile.getPath() : message + "discarded";
            Util.println(message);
        } else {
            Util.println(blockSeparator);
            Util.println("command output: ");
        }
        Process proc = null;
        try {
            if (vms) {
                proc = Runtime.getRuntime().exec(commandLine.toArray(new String[0]));
            } else {
                shell.execute();
                proc = shell.getProcess();
            }
            if (!daemon) {
                Thread hook = new Thread(proc::destroy);
                Runtime.getRuntime().addShutdownHook(hook);
                proc.getOutputStream().close();
                Util.redirectOutAndErrAndWait(proc);
                Runtime.getRuntime().removeShutdownHook(hook);
                Util.println("===============================");
                Util.println("command exit code: " + proc.exitValue());
                Util.println("");
                int n = proc.exitValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            if (!daemon && proc != null) {
                proc.destroy();
            }
        }
    }

    static File getOutputFile(File workDir, String outputFilePath) {
        if (outputFilePath != null) {
            outputFilePath = outputFilePath.trim();
        }
        File outputFile = null;
        if (Util.truthy(outputFilePath) && !(outputFile = new File(outputFilePath)).isAbsolute()) {
            outputFile = new File(workDir, outputFile.getPath()).getAbsoluteFile();
        }
        return outputFile;
    }

    static File getWorkDir(String directoryOffset) throws IOException {
        File workDir = new File(".").getCanonicalFile();
        if (Util.truthy(directoryOffset)) {
            workDir = new File(workDir, directoryOffset).getCanonicalFile();
        }
        if (workDir.isFile()) {
            throw new IllegalArgumentException("Working directory " + workDir + " is a file!");
        }
        return workDir;
    }

    static void initWindowsLibrary() {
        if (windows) {
            String arch = Util.getArch();
            File libraryPath = new File(PLUGIN_HOME, "lib/native/" + arch + "/WinAPI.dll");
            System.setProperty("com.urbancode.winapi.WinAPI.dllPath", libraryPath.getAbsolutePath());
        }
    }

    static void println(String line) {
        System.out.println(line);
    }

    static boolean truthy(Collection<?> c) {
        return c != null && !c.isEmpty();
    }

    static boolean truthy(Object o) {
        return o != null;
    }

    static boolean truthy(String s) {
        return s != null && !s.isEmpty();
    }

    private static void writeScriptFile(File scriptFile, String scriptBody) throws IOException {
        String defaultCharset = Util.getDefaultCharset();
        if (Util.truthy(defaultCharset)) {
            IO.writeTextFile(scriptFile, Util.denormalizeLines(scriptBody), defaultCharset);
        } else {
            IO.writeTextFile(scriptFile, Util.denormalizeLines(scriptBody), Util.getNativeEncoding());
        }
    }

    private static String denormalizeLines(String value) {
        return value.replaceAll("\\n|\\r\\n|\\r", Matcher.quoteReplacement(lineSep));
    }

    private static <T> T first(List<T> c) {
        if (c.isEmpty()) {
            throw new NoSuchElementException();
        }
        return c.get(0);
    }

    private static String getArch() {
        String arch = System.getProperty("os.arch").toLowerCase(Locale.US);
        String result = arch.indexOf("amd64") > -1 || arch.indexOf("x64") > -1 || arch.indexOf("x86_64") > -1 ? "x64" : (arch.indexOf("x86") > -1 || arch.indexOf("386") > -1 || arch.indexOf("486") > -1 || arch.indexOf("586") > -1 || arch.indexOf("686") > -1 || arch.indexOf("pentium") > -1 ? "x86" : (arch.indexOf("ia64") > -1 || arch.indexOf("itanium") > -1 || arch.indexOf("ia-64") > -1 ? "ia64" : (arch.indexOf("ppc") > -1 || arch.indexOf("powerpc") > -1 ? "ppc" : (arch.indexOf("sparc") > -1 ? "sparc" : (arch.indexOf("parisc") > -1 || arch.indexOf("pa_risc") > -1 || arch.indexOf("pa-risc") > -1 ? "parisc" : (arch.indexOf("alpha") > -1 ? "alpha" : (arch.indexOf("mips") > -1 ? "mips" : (arch.indexOf("arm") > -1 ? "arm" : "unknown"))))))));
        return result;
    }

    private static String getDefaultCharset() {
        String defaultCharset = null;
        if (Util.truthy(AGENT_HOME)) {
            File agentInstalledProps = new File(AGENT_HOME, "conf/agent/installed.properties");
            Properties agentProps = new Properties();
            try {
                FileInputStream agentInputStream = new FileInputStream(agentInstalledProps);
                agentProps.load(agentInputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            defaultCharset = agentProps.getProperty("system.default.encoding");
        }
        return defaultCharset;
    }

    public static File writeTemporaryScriptFile(String prefix, String ext, String body, String configuredTempDir) throws IOException {
        File written = null;
        if (!tempDirDetected) {
            File test;
            if (Util.truthy(configuredTempDir) && (written = Util.writeTemporaryScriptFile(prefix, ext, body, test = new File(configuredTempDir))) != null) {
                tempDir = test;
                tempDirDetected = true;
            }
            if (written == null && Util.truthy(System.getenv("PLUGIN_TEMP_DIRECTORY")) && (written = Util.writeTemporaryScriptFile(prefix, ext, body, test = new File(System.getenv("PLUGIN_TEMP_DIRECTORY")))) != null) {
                tempDir = test;
                tempDirDetected = true;
            }
            if (written == null && AGENT_HOME != null && (written = Util.writeTemporaryScriptFile(prefix, ext, body, test = new File(AGENT_HOME, "var" + File.separator + "temp"))) != null) {
                tempDir = test;
                tempDirDetected = true;
            }
            if (written == null) {
                tempDirDetected = true;
                tempDir = null;
            }
        }
        if (written == null) {
            written = File.createTempFile(prefix, ext, tempDir);
            Util.writeScriptFile(written, body);
        }
        return written;
    }

    private static File writeTemporaryScriptFile(String prefix, String ext, String body, File testDir) {
        File result = null;
        try {
            result = File.createTempFile(prefix, ext, testDir);
            Util.writeScriptFile(result, body);
        }
        catch (IOException e) {
            result = null;
        }
        return result;
    }

    private static Charset getNativeEncoding() {
        String encoding = System.getProperty("native.encoding");
        if (encoding != null) {
            return Charset.forName(encoding);
        }
        return Charset.defaultCharset();
    }

    private static void redirectOutAndErrAndWait(Process proc) throws InterruptedException, ExecutionException {
        WaitFuture out = processes.redirectOutput(proc, System.out);
        WaitFuture err = processes.redirectError(proc, System.err);
        out.await();
        err.await();
        proc.waitFor();
    }

    private static <T> List<T> tail(List<T> c) {
        if (c.isEmpty()) {
            throw new NoSuchElementException();
        }
        return c.subList(1, c.size());
    }

    private static List<String> tokenize(String s) {
        return Util.tokenize0(new StringTokenizer(s));
    }

    private static List<String> tokenize(String s, String delimiters) {
        return Util.tokenize0(new StringTokenizer(s, delimiters));
    }

    private static List<String> tokenize0(StringTokenizer tokenizer) {
        ArrayList<String> r = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            r.add(tokenizer.nextToken());
        }
        return r;
    }

    private Util() {
    }

    static {
        tempDirDetected = false;
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        String pathSep = System.getProperty("path.separator");
        windows = osName.contains("windows");
        vms = osName.contains("vms");
        os9 = osName.contains("mac") && !osName.endsWith("x");
        unix = ":".equals(pathSep) && !vms && !os9;
        zos = osName.contains("z/os");
        ibmi = osName.contains("os/400");
        PLUGIN_HOME = new File(System.getenv().get("PLUGIN_HOME"));
        lineSep = System.getProperty("line.separator");
        processes = new Processes();
        AGENT_HOME = Util.truthy(System.getenv("AGENT_HOME")) ? new File(System.getenv("AGENT_HOME")) : null;
    }
}

