/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.shell;

import com.urbancode.commons.util.IO;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;

class Util {
    static final boolean windows;
    static final boolean unix;
    static final boolean zos;
    static final boolean ibmi;
    static final File PLUGIN_HOME;
    static final File AGENT_HOME;
    private static File tempDir;
    static boolean tempDirDetected;

    static void setPosixExecutePermissions(File file) {
        Path p = file.getAbsoluteFile().toPath();
        try {
            Set<PosixFilePermission> perms = Files.getPosixFilePermissions(p, new LinkOption[0]);
            boolean setPerms = false;
            setPerms |= perms.add(PosixFilePermission.OWNER_EXECUTE);
            setPerms |= perms.add(PosixFilePermission.GROUP_EXECUTE);
            if (setPerms |= perms.add(PosixFilePermission.OTHERS_EXECUTE)) {
                Files.setPosixFilePermissions(p, perms);
            }
        }
        catch (UnsupportedOperationException perms) {
        }
        catch (IOException e) {
            Util.println("Unable to set execute permissions: " + e.getMessage());
        }
    }

    static List<String> createCommandLine(String interpreter, File scriptFile) {
        ArrayList<String> commandLine = new ArrayList<String>();
        if (Util.truthy(interpreter)) {
            if (windows) {
                commandLine.add("cmd");
                commandLine.add("/C");
                commandLine.add(interpreter);
            } else {
                commandLine.addAll(Util.tokenize(interpreter));
            }
        }
        commandLine.add(scriptFile.getAbsolutePath());
        return commandLine;
    }

    /*
     * Exception decompiling
     */
    static int executeShellCommand(File workDir, boolean daemon, List<String> commandLine, File outputFile, String blockSeparator) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static File getOutputFile(File workDir, String outputFilePath) {
        if (outputFilePath != null) {
            outputFilePath = outputFilePath.trim();
        }
        File outputFile = null;
        if (Util.truthy(outputFilePath) && !(outputFile = new File(outputFilePath)).isAbsolute()) {
            outputFile = new File(workDir, outputFile.getPath()).getAbsoluteFile();
        }
        return outputFile;
    }

    static File getWorkDir(String directoryOffset) throws IOException {
        File workDir = new File(".").getCanonicalFile();
        if (Util.truthy(directoryOffset)) {
            workDir = new File(workDir, directoryOffset).getCanonicalFile();
        }
        if (workDir.isFile()) {
            throw new IllegalArgumentException("Working directory " + workDir + " is a file!");
        }
        return workDir;
    }

    static void println(String line) {
        System.out.println(line);
    }

    static boolean truthy(Collection<?> c) {
        return c != null && !c.isEmpty();
    }

    static boolean truthy(Object o) {
        return o != null;
    }

    static boolean truthy(String s) {
        return s != null && !s.isEmpty();
    }

    private static void writeScriptFile(File scriptFile, String scriptBody) throws IOException {
        String defaultCharset = Util.getDefaultCharset();
        Charset charset = Util.truthy(defaultCharset) ? Charset.forName(defaultCharset) : Util.getNativeEncoding();
        IO.writeTextFile(scriptFile, Util.denormalizeLines(scriptBody), charset);
    }

    private static String denormalizeLines(String value) {
        return value.replaceAll("\\n|\\r\\n|\\r", Matcher.quoteReplacement(System.lineSeparator()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getDefaultCharset() {
        if (!Util.truthy(AGENT_HOME)) return null;
        File agentInstalledProps = new File(AGENT_HOME, "conf/agent/installed.properties");
        Properties props = new Properties();
        try (FileInputStream in = new FileInputStream(agentInstalledProps);){
            props.load(in);
            String string = props.getProperty("system.default.encoding");
            return string;
        }
        catch (IOException e) {
            Util.println("Unable to load agent system.default.encoding: " + e.getMessage());
        }
        return null;
    }

    static File writeTemporaryScriptFile(String prefix, String ext, String body, String configuredTempDir) throws IOException {
        File written = null;
        if (!tempDirDetected) {
            File test;
            String pluginTempDir;
            File test2;
            if (Util.truthy(configuredTempDir) && (written = Util.writeTemporaryScriptFile(prefix, ext, body, test2 = new File(configuredTempDir))) != null) {
                tempDir = test2;
                tempDirDetected = true;
            }
            if (written == null && Util.truthy(pluginTempDir = System.getenv("PLUGIN_TEMP_DIRECTORY")) && (written = Util.writeTemporaryScriptFile(prefix, ext, body, test = new File(pluginTempDir))) != null) {
                tempDir = test;
                tempDirDetected = true;
            }
            if (written == null && AGENT_HOME != null && (written = Util.writeTemporaryScriptFile(prefix, ext, body, test = new File(AGENT_HOME, "var" + File.separator + "temp"))) != null) {
                tempDir = test;
                tempDirDetected = true;
            }
            if (written == null) {
                tempDirDetected = true;
                tempDir = null;
            }
        }
        if (written == null) {
            written = File.createTempFile(prefix, ext, tempDir);
            Util.writeScriptFile(written, body);
        }
        return written;
    }

    private static File writeTemporaryScriptFile(String prefix, String ext, String body, File testDir) {
        try {
            File result = File.createTempFile(prefix, ext, testDir);
            Util.writeScriptFile(result, body);
            return result;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Charset getNativeEncoding() {
        String encoding = System.getProperty("native.encoding");
        if (encoding != null) {
            return Charset.forName(encoding);
        }
        return Charset.defaultCharset();
    }

    private static List<String> tokenize(String s) {
        StringTokenizer tokenizer = new StringTokenizer(s);
        ArrayList<String> r = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            r.add(tokenizer.nextToken());
        }
        return r;
    }

    private static Throwable getRootCause(Throwable throwable) {
        throwable.getClass();
        Throwable root = throwable;
        while (throwable != null) {
            root = throwable;
            throwable = throwable.getCause();
        }
        return root;
    }

    private static Closeable installDestroyOnShutdownHook(Process proc) {
        Runtime runtime = Runtime.getRuntime();
        Thread hook = new Thread(proc::destroy);
        Closeable toRemove = () -> runtime.removeShutdownHook(hook);
        runtime.addShutdownHook(hook);
        return toRemove;
    }

    private Util() {
    }

    static {
        tempDirDetected = false;
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        windows = osName.contains("windows");
        unix = ":".equals(File.pathSeparator);
        zos = osName.contains("z/os");
        ibmi = osName.contains("os/400");
        PLUGIN_HOME = new File(System.getenv("PLUGIN_HOME"));
        String agentHome = System.getenv("AGENT_HOME");
        AGENT_HOME = Util.truthy(agentHome) ? new File(agentHome) : null;
    }
}

