/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.shell;

import com.urbancode.air.plugin.shell.Util;
import com.urbancode.airplugins.AirPluginTool;
import java.io.File;
import java.util.List;
import java.util.Properties;

public class ShellStep {
    private final String[] args;

    public static void main(String[] args) {
        try {
            new ShellStep(args).run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    ShellStep(String[] args) {
        this.args = args;
        args.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() throws Exception {
        AirPluginTool apt = new AirPluginTool(this.args[0], this.args[1]);
        Properties props = apt.getStepProperties();
        String directoryOffset = props.getProperty("directoryOffset");
        boolean runAsDaemon = Boolean.parseBoolean(props.getProperty("runAsDaemon"));
        String interpreter = props.getProperty("shellInterpreter");
        String scriptBody = props.getProperty("scriptBody");
        String outputFilePath = props.getProperty("outputFile");
        String configuredTempDir = props.getProperty("tempDirectory");
        if (!Util.truthy(scriptBody)) {
            throw new IllegalArgumentException("Shell Script is required");
        }
        File workDir = Util.getWorkDir(directoryOffset);
        String scriptExt = ".tmp";
        if (!Util.truthy(interpreter)) {
            if (Util.windows) {
                scriptExt = ".bat";
            } else if (Util.unix) {
                boolean isRexx = false;
                if (Util.zos && scriptBody.startsWith("/*") && scriptBody.toLowerCase().contains("rexx")) {
                    scriptBody = scriptBody + "\n";
                    isRexx = true;
                }
                if (!scriptBody.startsWith("#!") && !isRexx) {
                    interpreter = "/bin/sh";
                }
                if (Util.ibmi) {
                    interpreter = "/QOpenSys/usr/bin/sh";
                }
            }
        }
        File outputFile = Util.getOutputFile(workDir, outputFilePath);
        workDir.mkdirs();
        int exitCode = 1;
        File scriptFile = Util.writeTemporaryScriptFile("shell_command_", scriptExt, scriptBody, configuredTempDir);
        try {
            if (Util.unix && !Util.truthy(interpreter)) {
                Util.setPosixExecutePermissions(scriptFile);
            }
            List<String> commandLine = Util.createCommandLine(interpreter, scriptFile);
            Util.println("");
            Util.println("command line: " + String.join((CharSequence)" ", commandLine));
            Util.println("script content: ");
            Util.println("-------------------------------");
            Util.println(scriptBody);
            Util.println("-------------------------------");
            Util.println("working directory: " + workDir.getPath());
            exitCode = Util.executeShellCommand(workDir, runAsDaemon, commandLine, outputFile, "===============================");
        }
        finally {
            if (!runAsDaemon) {
                scriptFile.delete();
            }
        }
        if (!runAsDaemon) {
            System.exit(exitCode);
        }
    }
}

