/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MultipleStreamConverter {
    private static final Logger log = Logger.getLogger((String)MultipleStreamConverter.class.getName());
    private static final int SIZE = 4096;
    private InputStream source;
    private List<InputStream> streamList = new ArrayList<InputStream>();
    private int listIndex = 0;
    private PipedOutputStream sink = new PipedOutputStream();
    private PipedInputStream inPipe;
    private Thread pumpThread = null;
    private Throwable pumpingException = null;
    private volatile boolean done = true;
    private boolean expectMore = true;

    public MultipleStreamConverter() {
        try {
            this.inPipe = new PipedInputStream(this.sink);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void doPump() {
        try {
            while (true) {
                if (!this.expectMore) {
                    if (this.streamList.size() <= this.listIndex) return;
                }
                if (this.inPipe == null) {
                    throw new IOException("Could not create stream pipes!");
                }
                if (this.streamList.size() > this.listIndex) {
                    int bytesRead;
                    this.source = this.streamList.get(this.listIndex);
                    ++this.listIndex;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = this.source.read(buffer)) != -1) {
                        this.sink.write(buffer, 0, bytesRead);
                    }
                    try {
                        this.source.close();
                    }
                    catch (IOException ioe) {
                        log.debug((Object)"Error pumping", (Throwable)ioe);
                    }
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException buffer) {}
            }
        }
        catch (Throwable t) {
            log.error((Object)t, t);
            this.setPumpingException(t);
            return;
        }
        finally {
            this.setDone(true);
            try {
                this.sink.flush();
                this.sink.close();
            }
            catch (IOException buffer) {}
            this.notifyAll();
        }
    }

    public InputStream getInputStream() {
        return this.inPipe;
    }

    public void addStream(InputStream source) {
        if (source != null) {
            this.streamList.add(source);
        }
    }

    public final synchronized void pump() {
        if (this.pumpThread != null) {
            throw new IllegalStateException("Pump already running");
        }
        this.pumpThread = Thread.currentThread();
        this.setDone(false);
        this.doPump();
    }

    public final synchronized void pumpAsynchronously() {
        if (this.pumpThread != null) {
            throw new IllegalStateException("Pump already running");
        }
        Runnable asynchronousPump = new Runnable(){

            public void run() {
                MultipleStreamConverter.this.doPump();
            }
        };
        this.pumpThread = new Thread(asynchronousPump);
        this.setDone(false);
        this.pumpThread.start();
    }

    public final synchronized void waitForCompletion() throws InterruptedException {
        if (this.pumpThread == null) {
            throw new IllegalStateException("Pump not running");
        }
        while (this.isNotDone()) {
            this.wait();
        }
    }

    public final synchronized void waitForCompletion(long millis) throws InterruptedException {
        if (this.pumpThread == null) {
            throw new IllegalStateException("Pump not running");
        }
        while (this.isNotDone()) {
            this.wait(millis);
        }
    }

    public final synchronized void waitForCompletion(long millis, int nanos) throws InterruptedException {
        if (this.pumpThread == null) {
            throw new IllegalStateException("Pump not running");
        }
        while (this.isNotDone()) {
            this.wait(millis, nanos);
        }
    }

    public Throwable getPumpingException() {
        return this.pumpingException;
    }

    protected void setPumpingException(Throwable pumpingException) {
        this.pumpingException = pumpingException;
    }

    public final synchronized void abort() {
        this.setDone(true);
        this.abortCleanup();
        this.notifyAll();
    }

    public void stop() {
        this.expectMore = false;
    }

    protected void abortCleanup() {
    }

    protected final boolean isDone() {
        return this.done;
    }

    protected final boolean isNotDone() {
        return !this.isDone();
    }

    protected final void setDone(boolean done) {
        this.done = done;
    }
}

