/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.shell.impersonation.unix;

import com.urbancode.commons.util.environment.Environment;
import com.urbancode.commons.util.processes.Processes;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class NativeProcessActions {
    private static final Logger log = Logger.getLogger(NativeProcessActions.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runPreExecuteAction(File suScript, String scriptPreExecuteAction, String user, File scriptLocation, String workingDirectory) throws IOException {
        block9: {
            List<String> commandLine = Arrays.asList(scriptPreExecuteAction, suScript.getAbsolutePath(), user, workingDirectory);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing command " + commandLine));
            }
            Processes processes = new Processes();
            ProcessBuilder builder = new ProcessBuilder(commandLine);
            Environment.getGlobalInstance().copyTo(builder.environment());
            builder.directory(scriptLocation);
            Process process = builder.start();
            try {
                processes.discardOutput(process);
                Future errorFuture = processes.getErrorStringFuture(process);
                if (process.waitFor() == 0) break block9;
                String message = "unknown cause";
                try {
                    message = (String)errorFuture.get();
                }
                catch (ExecutionException e) {
                    log.error((Object)"Unable to access pre-execute error message", (Throwable)e);
                }
                throw new IOException("Pre-execute action failed: " + message);
            }
            catch (InterruptedException swallow) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Swallowed interruption", (Throwable)swallow);
                }
            }
            finally {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runPostExecuteAction(File impersonationScript, String postExecuteAction, String user, String workingDirectory) {
        block12: {
            if (postExecuteAction.trim().length() == 0) {
                log.trace((Object)"Cannot run post-execute action because no action is defined");
                return;
            }
            List<String> commandLine = Arrays.asList(postExecuteAction, impersonationScript.getAbsolutePath(), user, workingDirectory);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing command " + commandLine));
            }
            Processes processes = new Processes();
            ProcessBuilder builder = new ProcessBuilder(commandLine);
            Environment.getGlobalInstance().copyTo(builder.environment());
            builder.directory(impersonationScript.getParentFile());
            try {
                Process process = builder.start();
                try {
                    processes.discardOutput(process);
                    Future errorFuture = processes.getErrorStringFuture(process);
                    if (process.waitFor() == 0) break block12;
                    String message = "unknown cause";
                    try {
                        message = (String)errorFuture.get();
                    }
                    catch (ExecutionException e) {
                        log.error((Object)"Unable to access pre-execute error message", (Throwable)e);
                    }
                    log.error((Object)("Post-execute action failed: " + message));
                }
                catch (InterruptedException swallow) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Swallowed interruption", (Throwable)swallow);
                    }
                }
                finally {
                    process.destroy();
                }
            }
            catch (IOException e) {
                log.error((Object)"Post-execute action failed", (Throwable)e);
            }
        }
    }
}

