/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.process.windows;

import com.urbancode.process.NativeProcess;
import com.urbancode.winapi.Handle;
import com.urbancode.winapi.RefInt;
import com.urbancode.winapi.WinApi;
import com.urbancode.winapi.WindowsException;
import com.urbancode.winapi.WindowsRuntimeException;
import java.io.InputStream;
import java.io.OutputStream;

class WindowsProcess
extends NativeProcess {
    private final Handle processHandle;
    private OutputStream outputStream;
    private InputStream inputStream;
    private InputStream errorStream;
    private int processId;
    private int exitCode;

    WindowsProcess(OutputStream outputStream, InputStream inputStream, InputStream errorStream, Handle processHandle, int processId) {
        this.processHandle = processHandle;
        this.outputStream = outputStream;
        this.inputStream = inputStream;
        this.errorStream = errorStream;
        this.processId = processId;
    }

    public synchronized void destroy() {
        block3: {
            if (this.processHandle.isOpen()) {
                try {
                    WinApi.TerminateProcess((Handle)this.processHandle, (int)1);
                }
                catch (WindowsException e) {
                    if (this.isTerminated()) break block3;
                    throw new WindowsRuntimeException(e);
                }
            }
        }
    }

    public synchronized int exitValue() {
        if (!this.isTerminated()) {
            throw new IllegalThreadStateException();
        }
        if (this.processHandle.isOpen()) {
            try {
                RefInt refExitCode = new RefInt();
                WinApi.GetExitCodeProcess((Handle)this.processHandle, (RefInt)refExitCode);
                this.exitCode = refExitCode.value;
            }
            catch (WindowsException e) {
                throw new WindowsRuntimeException(e);
            }
        }
        return this.exitCode;
    }

    public int waitFor() throws InterruptedException {
        int result;
        while (true) {
            try {
                result = this.exitValue();
            }
            catch (IllegalThreadStateException e) {
                Thread.sleep(250L);
                continue;
            }
            break;
        }
        return result;
    }

    public synchronized void destroyTree() {
        block3: {
            if (this.processHandle.isOpen()) {
                try {
                    WinApi.KillProcessEx((int)this.processId, (boolean)true);
                }
                catch (WindowsException e) {
                    if (this.isTerminated()) break block3;
                    throw new WindowsRuntimeException(e);
                }
            }
        }
    }

    public void releaseResources() {
        this.releaseResources(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void releaseResources(boolean closeStreams) {
        try {
            if (!closeStreams) return;
            try {
                OutputStream outputStream = this.outputStream;
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception errorStream2) {
                try {
                    InputStream inputStream = this.inputStream;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception errorStream) {
                    try {
                        InputStream errorStream3 = this.errorStream;
                        if (errorStream3 == null) return;
                        errorStream3.close();
                        return;
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        InputStream errorStream = this.errorStream;
                        if (errorStream == null) throw throwable;
                        errorStream.close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    InputStream errorStream = this.errorStream;
                    if (errorStream == null) return;
                    errorStream.close();
                    return;
                }
                catch (Exception errorStream) {
                    return;
                }
            }
            catch (Throwable throwable) {
                try {
                    InputStream inputStream = this.inputStream;
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception errorStream) {
                    throw throwable;
                }
                finally {
                    try {
                        InputStream errorStream = this.errorStream;
                        if (errorStream != null) {
                            errorStream.close();
                        }
                    }
                    catch (Exception errorStream) {}
                }
            }
            try {
                InputStream inputStream = this.inputStream;
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception errorStream) {
                try {
                    InputStream errorStream2 = this.errorStream;
                    if (errorStream2 == null) return;
                    errorStream2.close();
                    return;
                }
                catch (Exception errorStream2) {
                    return;
                }
            }
            catch (Throwable throwable) {
                try {
                    InputStream errorStream = this.errorStream;
                    if (errorStream == null) throw throwable;
                    errorStream.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                InputStream errorStream = this.errorStream;
                if (errorStream == null) return;
                errorStream.close();
                return;
            }
            catch (Exception errorStream) {
                return;
            }
        }
        finally {
            this.processHandle.closeNoError();
        }
    }

    private synchronized boolean isTerminated() {
        boolean result = true;
        if (this.processHandle.isOpen()) {
            try {
                result = WinApi.WaitForSingleObject((Handle)this.processHandle, (int)0) == 0;
            }
            catch (WindowsException e) {
                throw new WindowsRuntimeException(e);
            }
        }
        return result;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public InputStream getErrorStream() {
        return this.errorStream;
    }
}

