/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.process.unix;

import com.urbancode.commons.util.Check;
import com.urbancode.process.NativeProcess;
import java.io.InputStream;
import java.io.OutputStream;

class UnixProcess
extends NativeProcess {
    private OutputStream outputStream;
    private InputStream inputStream;
    private InputStream errorStream;
    private Process delegate;

    UnixProcess(InputStream errorStream, InputStream inputStream, OutputStream outputStream, Process process) {
        this.outputStream = outputStream;
        this.inputStream = inputStream;
        this.errorStream = errorStream;
        this.delegate = (Process)Check.nonNull((Object)process, (String)"process");
    }

    public synchronized void destroy() {
        this.delegate.destroy();
    }

    public void destroyTree() {
        this.destroy();
    }

    public int exitValue() {
        return this.delegate.exitValue();
    }

    public int waitFor() throws InterruptedException {
        return this.delegate.waitFor();
    }

    public void releaseResources() {
        this.releaseResources(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseResources(boolean closeStreams) {
        if (!closeStreams) return;
        try {
            OutputStream outputStream = this.outputStream;
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Exception errorStream) {
            try {
                InputStream inputStream = this.inputStream;
                if (inputStream == null) return;
                inputStream.close();
                return;
            }
            catch (Exception errorStream2) {
                return;
            }
            finally {
                try {
                    InputStream errorStream2 = this.errorStream;
                    if (errorStream2 != null) {
                        errorStream2.close();
                    }
                }
                catch (Exception errorStream2) {}
            }
        }
        catch (Throwable throwable) {
            try {
                InputStream inputStream = this.inputStream;
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (Exception errorStream) {
                throw throwable;
            }
            finally {
                try {
                    InputStream errorStream = this.errorStream;
                    if (errorStream != null) {
                        errorStream.close();
                    }
                }
                catch (Exception errorStream) {}
            }
        }
        try {
            InputStream inputStream = this.inputStream;
            if (inputStream == null) return;
            inputStream.close();
            return;
        }
        catch (Exception errorStream) {
            return;
        }
        finally {
            try {
                InputStream errorStream = this.errorStream;
                if (errorStream != null) {
                    errorStream.close();
                }
            }
            catch (Exception errorStream) {}
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public InputStream getErrorStream() {
        return this.errorStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }
}

