/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.xml;

import com.urbancode.commons.xml.XercesUtils;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;

public class XMLParserFactoryHardener {
    private volatile boolean disableValidation;
    private volatile boolean disableXmlSchema;
    private volatile boolean disableExternalResources;
    private volatile boolean disableDoctypeDeclarations;
    private volatile boolean disableExpensiveProcessing;
    private volatile boolean disableXIncludeAwareness;

    public XMLParserFactoryHardener() {
        this.setDisableValidation(true);
        this.setDisableXmlSchema(true);
        this.setDisableExpensiveProcessing(true);
        this.setDisableXIncludeAwareness(true);
        this.setDisableExternalResources(true);
    }

    public void useParserSettings() {
        this.setDisableValidation(false);
        this.setDisableXmlSchema(false);
        this.setDisableExternalResources(false);
        this.setDisableDoctypeDeclarations(false);
        this.setDisableExpensiveProcessing(false);
        this.setDisableXIncludeAwareness(false);
    }

    public void useMostSecureSettings() {
        this.setDisableValidation(true);
        this.setDisableXmlSchema(true);
        this.setDisableExternalResources(true);
        this.setDisableDoctypeDeclarations(true);
        this.setDisableExpensiveProcessing(true);
        this.setDisableXIncludeAwareness(true);
    }

    public boolean isDisableXmlSchema() {
        return this.disableXmlSchema;
    }

    public void setDisableXmlSchema(boolean disableXmlSchema) {
        this.disableXmlSchema = disableXmlSchema;
    }

    public boolean isDisableExternalResources() {
        return this.disableExternalResources;
    }

    public void setDisableExternalResources(boolean disableExternalResources) {
        this.disableExternalResources = disableExternalResources;
    }

    public boolean isDisableDoctypeDeclarations() {
        return this.disableDoctypeDeclarations;
    }

    public void setDisableDoctypeDeclarations(boolean disableDoctypeDeclarations) {
        this.disableDoctypeDeclarations = disableDoctypeDeclarations;
    }

    public boolean isDisableExpensiveProcessing() {
        return this.disableExpensiveProcessing;
    }

    public void setDisableExpensiveProcessing(boolean disableExpensiveProcessing) {
        this.disableExpensiveProcessing = disableExpensiveProcessing;
    }

    public boolean isDisableValidation() {
        return this.disableValidation;
    }

    public void setDisableValidation(boolean disableValidation) {
        this.disableValidation = disableValidation;
    }

    public boolean isDisableXIncludeAwareness() {
        return this.disableXIncludeAwareness;
    }

    public void setDisableXIncludeAwareness(boolean disableXIncludeAwareness) {
        this.disableXIncludeAwareness = disableXIncludeAwareness;
    }

    public void harden(DocumentBuilderFactory factory) {
        this.harden0(new DOMFactory(factory));
    }

    public void harden(SAXParserFactory factory) {
        this.harden0(new SAXFactory(factory));
    }

    private void harden0(Factory factory) {
        boolean disableValidation = this.isDisableValidation();
        boolean disableXmlSchema = this.isDisableXmlSchema();
        boolean disableExternalResources = this.isDisableExternalResources();
        boolean disableDoctypeDeclarations = this.isDisableDoctypeDeclarations();
        boolean disableExpensiveProcessing = this.isDisableExpensiveProcessing();
        boolean disableXIncludeAwareness = this.isDisableXIncludeAwareness();
        if (disableXIncludeAwareness) {
            factory.setXIncludeAware(false);
        }
        if (disableValidation) {
            factory.setValidating(false);
        }
        if (disableXmlSchema) {
            factory.setFeature("http://apache.org/xml/features/validation/schema", false);
            factory.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
        }
        if (disableExternalResources) {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        if (disableDoctypeDeclarations) {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        if (disableExpensiveProcessing) {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
    }

    private static final class SAXFactory
    implements Factory {
        final SAXParserFactory factory;

        SAXFactory(SAXParserFactory factory) {
            this.factory = factory;
        }

        public void setValidating(boolean validating) {
            this.factory.setValidating(validating);
        }

        public void setXIncludeAware(boolean xIncludeAware) {
            this.factory.setXIncludeAware(xIncludeAware);
        }

        public void setFeature(String name, boolean value) {
            XercesUtils.silentSetFeature(this.factory, name, value);
        }
    }

    private static final class DOMFactory
    implements Factory {
        final DocumentBuilderFactory factory;

        DOMFactory(DocumentBuilderFactory factory) {
            this.factory = factory;
        }

        public void setValidating(boolean validating) {
            this.factory.setValidating(validating);
        }

        public void setXIncludeAware(boolean xIncludeAware) {
            this.factory.setXIncludeAware(xIncludeAware);
        }

        public void setFeature(String name, boolean value) {
            XercesUtils.silentSetFeature(this.factory, name, value);
        }
    }

    private static interface Factory {
        public void setValidating(boolean var1);

        public void setXIncludeAware(boolean var1);

        public void setFeature(String var1, boolean var2);
    }
}

