/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.shell;

import com.urbancode.air.plugin.shell.Util;
import com.urbancode.airplugins.AirPluginTool;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class XArgsStep {
    private final String[] args;

    public static void main(String[] args) {
        try {
            new XArgsStep(args).run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    XArgsStep(String[] args) {
        this.args = args;
        args.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() throws Exception {
        Util.initWindowsLibrary();
        AirPluginTool apt = new AirPluginTool(this.args[0], this.args[1]);
        Properties props = apt.getStepProperties();
        String directoryOffset = props.getProperty("directoryOffset");
        boolean runAsDaemon = Boolean.parseBoolean(props.getProperty("runAsDaemon"));
        String interpreter = props.getProperty("shellInterpreter");
        String scriptBody = props.getProperty("scriptBody");
        String outputFilePath = props.getProperty("outputFile");
        String xargs = props.getProperty("xargs");
        String xargsDelimiter = props.getProperty("xargsDelimiter");
        boolean runOncePerArg = Boolean.parseBoolean(props.getProperty("runOncePerArg"));
        String configuredTempDir = props.getProperty("tempDirectory");
        if (!Util.truthy(scriptBody)) {
            throw new IllegalArgumentException("Shell Script is required");
        }
        File workDir = Util.getWorkDir(directoryOffset);
        String scriptExt = null;
        if (!Util.truthy(interpreter)) {
            if (Util.windows) {
                scriptExt = ".bat";
            } else if (Util.vms) {
                scriptExt = ".com";
                scriptBody = Util.createVmsScriptBody(workDir, scriptBody);
            } else if (Util.unix && !scriptBody.startsWith("#!")) {
                interpreter = "/bin/sh";
            }
        }
        File outputFile = Util.getOutputFile(workDir, outputFilePath);
        workDir.mkdirs();
        Util.println("delimiter specified is " + xargsDelimiter);
        String[] xargArray = Util.truthy(xargsDelimiter) ? xargs.split(xargsDelimiter) : xargs.split(",");
        Util.println("executing script for all values in " + xargs);
        int exitCode = 0;
        boolean daemon = runAsDaemon && !Util.vms;
        File scriptFile = Util.writeTemporaryScriptFile("shell_command_", scriptExt, scriptBody, configuredTempDir);
        try {
            if (Util.unix && !Util.truthy(interpreter)) {
                Util.chmod(scriptFile);
            }
            int xargExitCode = 0;
            List<CommandLine> commandLines = XArgsStep.buildCommandLines(scriptFile, interpreter, runOncePerArg, xargArray);
            for (CommandLine cmd : commandLines) {
                Util.println("");
                Util.println("-------------------------------");
                Util.println("executing script for values: " + String.join((CharSequence)",", cmd.argList));
                Util.println(String.join((CharSequence)" ", cmd.commandLine));
                xargExitCode = Util.executeShellCommand(workDir, daemon, cmd.commandLine, outputFile, "-------------------------------");
                if (exitCode != 0 || xargExitCode == 0) continue;
                exitCode = xargExitCode;
            }
        }
        finally {
            if (!daemon) {
                scriptFile.delete();
            }
        }
        if (!daemon) {
            System.exit(exitCode);
        }
    }

    static List<CommandLine> buildCommandLines(File scriptFile, String interpreter, boolean runOncePerArg, String[] xargArray) {
        ArrayList<CommandLine> commands = new ArrayList<CommandLine>();
        int commandLineLengthLimit = runOncePerArg ? 0 : 8190;
        List<String> commandPrefix = Util.createCommandLine(interpreter, scriptFile);
        int commandPrefixLength = commandPrefix.size() - 1;
        for (String s : commandPrefix) {
            commandPrefixLength += XArgsStep.getArgLength(s);
        }
        int commandLineLength = 0;
        ArrayList<String> commandLine = new ArrayList<String>();
        ArrayList<String> argList = new ArrayList<String>();
        for (String xarg : xargArray) {
            boolean limitReached;
            int xargLen = XArgsStep.getArgLength(xarg);
            boolean bl = limitReached = commandLineLength + 1 + xargLen > commandLineLengthLimit;
            if (limitReached && commandLineLength != 0) {
                commands.add(new CommandLine(commandLine, argList));
                commandLine = new ArrayList();
                argList = new ArrayList();
            }
            if (commandLine.isEmpty()) {
                commandLine.addAll(commandPrefix);
                commandLineLength = commandPrefixLength;
            }
            commandLine.add(xarg);
            argList.add(xarg);
            commandLineLength += 1 + xargLen;
        }
        if (!commandLine.isEmpty()) {
            commands.add(new CommandLine(commandLine, argList));
        }
        return commands;
    }

    static int getArgLength(String arg) {
        return arg.length();
    }

    static final class CommandLine {
        final List<String> commandLine;
        final List<String> argList;

        CommandLine(List<String> commandLine, List<String> argList) {
            this.commandLine = commandLine;
            this.commandLine.getClass();
            this.argList = argList;
            this.argList.getClass();
        }
    }
}

