/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

final def DATE_READ_1 = new java.text.SimpleDateFormat("E MMM dd HH:mm:ss zzz yyyy") // java.util.Date.toString()
final def DATE_READ_2 = new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss z") // ISO-like format
    
if (revisionNum && !revisionNum.startsWith('${')) {
    // validate revision is a number
    if (!revisionNum.isLong()) {
        errors.revisionNum = 'Revision must be a whole number'
    }
}

if (revisionDate && !revisionDate.startsWith('${')) {
    boolean valid = false
    // validate revisionDate format
    
    if (revisionDate.isLong()) {
        // is milliseconds since epoch, valid
        valid = true;
    } else {
        [DATE_READ_1, DATE_READ_2].each{format ->
            try {
                format.parse(revisionDate)
                valid = true
            }
            catch (java.text.ParseException e) {
                // not a match for this format
            }
        }
    }
    
    if (!valid) {
        errors.revisionDate = 'Date is not a valid format'
    }
}

if (revisionNum && revisionDate) {
    if (!revisionNum.startsWith('${') || !revisionDate.startsWith('${')) {
        // revisionand revisionDate are both present and non-dynamic
        errors.revisionNum = 'Revision and Date can not both be specified'
        errors.revisionDate = 'Revision and Date can not both be specified'
    }
}