/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.SvnClient;
import com.urbancode.commons.fileutils.FileUtils;
import com.urbancode.commons.util.IO;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.log4j.PropertyConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportVersion {
    private Properties inputProperties;
    private Properties outputProperties;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute() {
        VersionClient versionClient;
        HashSet<String> versionsToCleanupOnError;
        File tempDir;
        int returnCode;
        block37: {
            Iterator<Object> i$;
            List currentVersions;
            SvnClient svnClient;
            boolean isUseVFS;
            boolean preserveExecutePermissions;
            boolean watchTags;
            String[] excludes;
            String[] includes;
            String componentName;
            Charset charset;
            String[] extensions;
            block36: {
                returnCode = 0;
                tempDir = null;
                versionsToCleanupOnError = new HashSet<String>();
                versionClient = null;
                try {
                    Properties props = new Properties();
                    props.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/log4j.properties")));
                    PropertyConfigurator.configure((Properties)props);
                    Properties agentProps = new Properties();
                    agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
                    String charsetName = agentProps.getProperty("system.default.encoding");
                    String extensionString = this.inputProperties.getProperty("extensions");
                    extensions = new String[]{};
                    if (extensionString != null) {
                        extensions = extensionString.split(",");
                        for (int i = 0; i < extensions.length; ++i) {
                            extensions[i] = extensions[i].trim();
                        }
                    }
                    charset = null;
                    if (charsetName != null) {
                        charset = Charset.forName(charsetName);
                    }
                    boolean isAutoIntegration = Boolean.valueOf(this.inputProperties.getProperty("isAutoIntegration"));
                    componentName = this.inputProperties.getProperty("componentName");
                    String repoUrl = this.inputProperties.getProperty("repoUrl");
                    String svnUser = this.inputProperties.getProperty("user");
                    String svnPassword = this.inputProperties.getProperty("password");
                    String svnProxyHost = this.inputProperties.getProperty("svnProxyHost");
                    String svnProxyPort = this.inputProperties.getProperty("svnProxyPort");
                    String svnProxyUser = this.inputProperties.getProperty("svnProxyUser");
                    String svnProxyPass = this.inputProperties.getProperty("svnProxyPass");
                    includes = this.splitLines(this.inputProperties.getProperty("includes"));
                    if (includes.length == 0) {
                        includes = new String[]{"**/*"};
                    }
                    excludes = this.splitLines(this.inputProperties.getProperty("excludes"));
                    String svnPath = this.inputProperties.getProperty("svnPath");
                    String revision = this.inputProperties.getProperty("versionOrTag");
                    watchTags = Boolean.valueOf(this.inputProperties.getProperty("watchTags"));
                    preserveExecutePermissions = Boolean.valueOf(this.inputProperties.getProperty("saveFileExecuteBits"));
                    isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
                    String username = "PasswordIsAuthToken";
                    String password = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
                    String webUrl = System.getenv("AH_WEB_URL");
                    URI url = new URI(webUrl);
                    versionClient = new VersionClient(url, username, password);
                    ComponentClient componentClient = new ComponentClient(url, username, password);
                    svnClient = new SvnClient(svnPath, repoUrl, svnUser, svnPassword, svnProxyHost, svnProxyPort, svnProxyUser, svnProxyPass);
                    List<Object> versionsToImport = new ArrayList<String>();
                    if (isAutoIntegration) {
                        String latestVersion = componentClient.getLatestVersion(componentName);
                        if (latestVersion == null) {
                            String svnVersionOrTag = this.getVersionOrTag(svnClient, watchTags, revision);
                            versionsToImport.add(svnVersionOrTag);
                        } else {
                            versionsToImport = this.getRevisionsOrTagsSince(svnClient, latestVersion, watchTags);
                        }
                    } else {
                        String svnVersionOrTag = this.getVersionOrTag(svnClient, watchTags, revision);
                        versionsToImport.add(svnVersionOrTag);
                    }
                    currentVersions = componentClient.getComponentVersions(componentName, Boolean.valueOf(false));
                    if (versionsToImport.size() > 0) {
                        i$ = versionsToImport.iterator();
                        break block36;
                    }
                    System.out.println("Found no new versions to import");
                    break block37;
                }
                catch (Exception e) {
                    try {
                        System.err.println(String.format("Error Creating New Version: %s", e.getMessage()));
                        e.printStackTrace();
                        returnCode = 1;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (tempDir == null) throw throwable;
                            if (!tempDir.exists()) throw throwable;
                            FileUtils.deleteFile((File)tempDir);
                            throw throwable;
                        }
                        catch (Throwable t) {
                            System.err.println(String.format("Error deleting tempDir", t));
                            throw throwable;
                        }
                        finally {
                            if (returnCode != 0) {
                                this.deleteVersions(versionsToCleanupOnError, versionClient);
                            }
                        }
                    }
                    try {
                        if (tempDir == null) return returnCode;
                        if (!tempDir.exists()) return returnCode;
                        FileUtils.deleteFile((File)tempDir);
                        return returnCode;
                    }
                    catch (Throwable t) {
                        System.err.println(String.format("Error deleting tempDir", t));
                        return returnCode;
                    }
                    finally {
                        if (returnCode != 0) {
                            this.deleteVersions(versionsToCleanupOnError, versionClient);
                        }
                    }
                }
            }
            while (i$.hasNext()) {
                String string = (String)i$.next();
                boolean hasVersion = currentVersions.contains(string);
                if (!hasVersion) {
                    System.out.println("Creating Version: " + string);
                    String versionId = versionClient.createVersion(componentName, string, " ").toString();
                    versionsToCleanupOnError.add(versionId);
                    this.outputProperties.setProperty("VersionID", versionId);
                    if (isUseVFS) {
                        tempDir = this.downloadFiles(svnClient, string, watchTags);
                        System.out.println("Uploading artifact files.");
                        versionClient.addVersionFiles(componentName, versionId, tempDir, "", includes, excludes, preserveExecutePermissions, true, charset, extensions);
                    } else {
                        System.out.println("Skipping Artifact Upload: Component is configured not to use codestation.");
                    }
                    if (tempDir == null || !tempDir.exists()) continue;
                    FileUtils.deleteFile((File)tempDir);
                    continue;
                }
                System.out.println(String.format("Component Already Has Version: %s", string));
            }
        }
        try {
            if (tempDir == null) return returnCode;
            if (!tempDir.exists()) return returnCode;
            FileUtils.deleteFile((File)tempDir);
            return returnCode;
        }
        catch (Throwable t) {
            System.err.println(String.format("Error deleting tempDir", t));
            return returnCode;
        }
        finally {
            if (returnCode != 0) {
                this.deleteVersions(versionsToCleanupOnError, versionClient);
            }
        }
    }

    private String[] splitLines(String string) {
        ArrayList<String> lines = new ArrayList<String>();
        if (string != null) {
            BufferedReader in = IO.buffer(IO.reader(string));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    lines.add(line);
                }
            }
            catch (IOException impossible) {
                throw new RuntimeException(impossible);
            }
        }
        return lines.toArray(new String[lines.size()]);
    }

    private void deleteVersions(Set<String> versionIds, VersionClient vc) {
        for (String version : versionIds) {
            try {
                System.out.println("Deleting incomplete version: " + version);
                vc.deleteVersion(UUID.fromString(version));
            }
            catch (Throwable t) {
                System.err.println("Error deleting version: " + version);
                t.printStackTrace();
            }
        }
    }

    private String getVersionOrTag(SvnClient svn, boolean watchTags, String revision) throws IOException {
        String result;
        if (watchTags) {
            System.out.println("Checking for tag");
            result = revision != null && revision.trim().length() > 0 ? revision : svn.getLatestTag();
        } else if (revision != null && revision.length() > 0) {
            System.out.println("Using specific revision " + revision);
            result = revision;
        } else {
            System.out.println("Checking for version");
            result = svn.getLatestVersion();
        }
        return result;
    }

    private List<String> getRevisionsOrTagsSince(SvnClient svn, String latest, boolean watchTags) throws IOException {
        List<String> result = null;
        result = watchTags ? svn.getTagsSince(latest) : svn.getRevisionsSince(latest);
        return result;
    }

    private File downloadFiles(SvnClient svn, String svnVersionOrTag, boolean watchTags) throws IOException {
        File result = watchTags ? svn.downloadTaggedFiles(svnVersionOrTag) : svn.downloadFiles(svnVersionOrTag);
        return result;
    }
}

