/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.ObjectUtil;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.ParseException;

@BridgeMethodsAdded
public class SynchronizedDecimalFormat
implements Serializable {
    private static final long serialVersionUID = 7460451663422561855L;
    private DecimalFormat format;
    private String pattern;

    public static synchronized SynchronizedDecimalFormat getInstance(String pattern) {
        return new SynchronizedDecimalFormat(pattern);
    }

    private SynchronizedDecimalFormat(String pattern) {
        this.format = new DecimalFormat(pattern);
        this.pattern = pattern;
    }

    public synchronized String format(Number number) {
        return this.format.format(number);
    }

    public synchronized Number parse(String s) throws ParseException {
        return this.format.parse(s);
    }

    public String toPattern() {
        return this.pattern;
    }

    public int hashCode() {
        return (this.format == null ? 17 : this.format.hashCode()) * 17 + (this.pattern == null ? 5 : this.pattern.hashCode()) * 5;
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (object != null && object instanceof SynchronizedDecimalFormat) {
            SynchronizedDecimalFormat syncformat = (SynchronizedDecimalFormat)object;
            equals = true;
            equals = ObjectUtil.isEqual(this.format, syncformat.format) && ObjectUtil.isEqual(this.pattern, syncformat.pattern);
        }
        return equals;
    }
}

