/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.processes.Processes;
import com.urbancode.commons.xml.DocumentBuilderFactoryBuilder;
import com.urbancode.commons.xml.XPathUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnClient {
    final String LAST_CHANGED_REV = "Last Changed Rev:";
    private final String svnPath;
    private final String url;
    private final String user;
    private final String password;
    private final DocumentBuilder docBuilder;
    private final XPath xPath;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private XPathExpression revXPath;
    private XPathExpression entryRevXPath;
    private XPathExpression entryNameXPath;

    public SvnClient(String svnPath, String url, String user, String password, String proxyHost, String proxyPort, String proxyUsername, String proxyPassword) throws IOException {
        this.svnPath = svnPath.trim();
        this.url = url.trim();
        this.user = user;
        this.password = password;
        if (proxyHost != null) {
            this.proxyHost = proxyHost.trim();
            if (proxyPort != null) {
                this.proxyPort = proxyPort.trim();
            }
            if (proxyUsername != null) {
                this.proxyUsername = proxyUsername.trim();
            }
            if (proxyPassword != null) {
                this.proxyPassword = proxyPassword.trim();
            }
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactoryBuilder.newBuilder().newDocumentBuilderFactory();
            this.docBuilder = factory.newDocumentBuilder();
            XPathFactory xPathFactory = XPathFactory.newInstance();
            this.xPath = xPathFactory.newXPath();
            this.revXPath = this.xPath.compile("@revision");
            this.entryRevXPath = this.xPath.compile("./commit/@revision");
            this.entryNameXPath = this.xPath.compile("./name/text()");
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public List<String> getRevisionsSince(String latest) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(this.getCommandBaseline("log"));
        command.add("-r");
        command.add(latest + ":HEAD");
        command.add("--verbose");
        command.add("--xml");
        command.add(this.url);
        System.out.println("Running command: " + StringUtils.join(command, (String)" "));
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future errorFuture = processes.getErrorStringFuture(process);
            XPathExpression revisions = this.getRevisionsSinceXPathExpression();
            Document document = this.docBuilder.parse(process.getInputStream());
            NodeList list = (NodeList)revisions.evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < list.getLength(); ++i) {
                Node revNode = list.item(i);
                String revId = this.revXPath.evaluate(revNode);
                if (revId.equals(latest)) continue;
                result.add(revId);
            }
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("SVN error: " + (String)errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
        return result;
    }

    private XPathExpression getRevisionsSinceXPathExpression() {
        XPathExpression result = null;
        try {
            result = this.xPath.compile("/log/logentry");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public List<String> getTagsSince(String latest) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(this.getCommandBaseline("list"));
        command.add("--xml");
        command.add(this.url);
        System.out.println("Running command: " + StringUtils.join(command, (String)" "));
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future errorFuture = processes.getErrorStringFuture(process);
            Document document = this.docBuilder.parse(process.getInputStream());
            XPathExpression latestEntryXPath = this.getSpecificEntryXPathExpression(latest);
            Node latestEntry = (Node)latestEntryXPath.evaluate(document, XPathConstants.NODE);
            long latestRev = -1L;
            if (latestEntry != null) {
                latestRev = Long.valueOf(this.entryRevXPath.evaluate(latestEntry));
            }
            XPathExpression entryXPath = this.getEntryXPathExpression();
            NodeList entryList = (NodeList)entryXPath.evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < entryList.getLength(); ++i) {
                Node entryNode = entryList.item(i);
                Long rev = Long.valueOf(this.entryRevXPath.evaluate(entryNode));
                if (rev <= latestRev) continue;
                result.add(this.entryNameXPath.evaluate(entryNode));
            }
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("SVN error: " + (String)errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
        return result;
    }

    private XPathExpression getSpecificEntryXPathExpression(String latest) {
        XPathExpression result = null;
        try {
            XPathUtils utils = new XPathUtils();
            result = this.xPath.compile("/lists/list/entry[./name/text()=" + utils.quotedXPathString(latest) + "]");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private XPathExpression getEntryXPathExpression() {
        XPathExpression result = null;
        try {
            XPathUtils utils = new XPathUtils();
            result = this.xPath.compile("/lists/list/entry");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public String getLatestTag() throws IOException {
        String result = null;
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(this.getCommandBaseline("log"));
        command.add("--limit");
        command.add("1");
        command.add("--verbose");
        command.add("--xml");
        command.add(this.url);
        System.out.println("Running command: " + StringUtils.join(command, (String)" "));
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            int status;
            Future errorFuture = processes.getErrorStringFuture(process);
            Document document = this.docBuilder.parse(process.getInputStream());
            Number number = (Number)this.xPath.evaluate("count(/log/logentry/paths/path)", document, XPathConstants.NUMBER);
            String action = this.xPath.evaluate("/log/logentry/paths/path[1]/@action", document);
            if (number != null && number.intValue() == 1 && "A".equals(action)) {
                int slashIndex;
                result = this.xPath.evaluate("/log/logentry/paths/path[1]/text()", document);
                if (result != null && (slashIndex = result.lastIndexOf(47)) >= 0) {
                    result = result.substring(slashIndex + 1);
                }
                if (result != null && result.length() == 0) {
                    result = null;
                }
            }
            if ((status = process.waitFor()) != 0) {
                throw new IOException("SVN error: " + (String)errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
        return result;
    }

    public String getLatestVersion() throws IOException {
        String result = null;
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(this.getCommandBaseline("info"));
        command.add(this.url);
        System.out.println("Running command: " + StringUtils.join(command, (String)" "));
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            String line;
            Future errorFuture = processes.getErrorStringFuture(process);
            BufferedReader outputReader = IO.buffer((Reader)IO.reader((String)processes.getOutputString(process)));
            while ((line = outputReader.readLine()) != null) {
                if (!line.startsWith("Last Changed Rev:")) continue;
                result = line.substring("Last Changed Rev:".length()).trim();
            }
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("SVN error: " + (String)errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
        if (result == null) {
            throw new IOException("Version not found");
        }
        return result;
    }

    public File downloadFiles(String version) throws IOException {
        File result = this.getTempDir();
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(this.getCommandBaseline("export"));
        command.add("--revision");
        command.add(version);
        command.add(this.url);
        command.add(result.getAbsolutePath());
        System.out.println("Running command: " + StringUtils.join(command, (String)" "));
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future errorFuture = processes.getErrorStringFuture(process);
            IO.copy((InputStream)process.getInputStream(), (OutputStream)IO.NULL);
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("SVN error: " + (String)errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
        return result;
    }

    public File downloadTaggedFiles(String tag) throws IOException {
        File result = this.getTempDir();
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(this.getCommandBaseline("export"));
        command.add(this.url + "/" + tag);
        command.add(result.getAbsolutePath());
        System.out.println("Running command: " + StringUtils.join(command, (String)" "));
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future errorFuture = processes.getErrorStringFuture(process);
            IO.copy((InputStream)process.getInputStream(), (OutputStream)IO.NULL);
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("SVN error: " + (String)errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
        return result;
    }

    private File getTempDir() throws IOException {
        return new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
    }

    private List<String> getCommandBaseline(String cmd) {
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(this.svnPath, cmd, "--no-auth-cache", "--non-interactive", "--trust-server-cert"));
        if (this.user != null && this.user.length() > 0) {
            command.add("--username");
            command.add(this.user);
            if (this.password != null && this.password.length() > 0) {
                command.add("--password");
                command.add(this.password);
            } else {
                System.out.println("WARNING: username is specified but password is empty.");
            }
        }
        if (this.proxyHost != null && this.proxyHost.length() > 0) {
            command.add("--config-option");
            command.add("servers:global:http-proxy-host=" + this.proxyHost);
            if (this.proxyPort != null && this.proxyPort.length() > 0) {
                command.add("--config-option");
                command.add("servers:global:http-proxy-port=" + this.proxyPort);
            }
            if (this.proxyUsername != null && this.proxyUsername.length() > 0) {
                command.add("--config-option");
                command.add("servers:global:http-proxy-username=" + this.proxyUsername);
                if (this.proxyPassword != null && this.proxyPassword.length() > 0) {
                    command.add("--config-option");
                    command.add("servers:global:http-proxy-password=" + this.proxyPassword);
                } else {
                    System.out.println("WARNING: proxy username is specified but proxy password is empty.");
                }
            }
        }
        return command;
    }
}

