/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.nonull;

import com.urbancode.commons.util.immutable.IImmutableCollection;
import com.urbancode.commons.util.immutable.IImmutableList;
import com.urbancode.commons.util.immutable.IImmutableMap;
import com.urbancode.commons.util.immutable.IImmutableSet;
import com.urbancode.commons.util.immutable.IImmutableVector;
import com.urbancode.commons.util.nonull.NonNull;
import com.urbancode.commons.util.nonull.NonNullCollection;
import com.urbancode.commons.util.nonull.NonNullImmutableCollection;
import com.urbancode.commons.util.nonull.NonNullImmutableList;
import com.urbancode.commons.util.nonull.NonNullImmutableMap;
import com.urbancode.commons.util.nonull.NonNullImmutableSet;
import com.urbancode.commons.util.nonull.NonNullImmutableVector;
import com.urbancode.commons.util.nonull.NonNullMap;
import com.urbancode.commons.util.nonull.NonNullQueue;
import com.urbancode.commons.util.nonull.NonNullRandomAccessImmutableVector;
import com.urbancode.commons.util.nonull.NonNullRandomAccessList;
import com.urbancode.commons.util.nonull.NonNullSequentialList;
import com.urbancode.commons.util.nonull.NonNullSet;
import com.urbancode.commons.util.nonull.NonNullSortedMap;
import com.urbancode.commons.util.nonull.NonNullSortedSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public final class NonNullCollections {
    public static <T> Collection<T> nonNullCollection(Collection<T> c) {
        if (c instanceof NonNull) {
            return c;
        }
        return new NonNullCollection<T>(c);
    }

    public static <T> List<T> nonNullList(List<T> c) {
        if (c instanceof NonNull) {
            return c;
        }
        if (c instanceof RandomAccess) {
            return new NonNullRandomAccessList<T>(c);
        }
        return new NonNullSequentialList<T>(c);
    }

    public static <T> Set<T> nonNullSet(Set<T> c) {
        if (c instanceof NonNull) {
            return c;
        }
        return new NonNullSet<T>(c);
    }

    public static <T> SortedSet<T> nonNullSortedSet(SortedSet<T> c) {
        if (c instanceof NonNull) {
            return c;
        }
        return new NonNullSortedSet<T>(c);
    }

    public static <K, V> Map<K, V> nonNullMap(Map<K, V> c) {
        if (c instanceof NonNull) {
            return c;
        }
        return new NonNullMap<K, V>(c);
    }

    public static <K, V> SortedMap<K, V> nonNullSortedMap(SortedMap<K, V> c) {
        if (c instanceof NonNull) {
            return c;
        }
        return new NonNullSortedMap<K, V>(c);
    }

    public static <T> Queue<T> nonNullQueue(Queue<T> c) {
        if (c instanceof NonNull) {
            return c;
        }
        return new NonNullQueue<T>(c);
    }

    public static <T> IImmutableCollection<T> nonNullImmutableCollection(IImmutableCollection<T> c) {
        if (c instanceof NonNull) {
            return c;
        }
        return new NonNullImmutableCollection<T>(c);
    }

    public static <T> IImmutableSet<T> nonNullImmutableSet(IImmutableSet<T> c) {
        if (c instanceof NonNull) {
            return c;
        }
        return new NonNullImmutableSet<T>(c);
    }

    public static <T> IImmutableList<T> nonNullImmutableList(IImmutableList<T> c) {
        if (c instanceof NonNull) {
            return c;
        }
        return new NonNullImmutableList<T>(c);
    }

    public static <T> IImmutableVector<T> nonNullImmutableVector(IImmutableVector<T> c) {
        if (c instanceof NonNull) {
            return c;
        }
        if (c instanceof RandomAccess) {
            return new NonNullRandomAccessImmutableVector<T>(c);
        }
        return new NonNullImmutableVector<T>(c);
    }

    public static <K, V> IImmutableMap<K, V> nonNullImmutableMap(IImmutableMap<K, V> c) {
        if (c instanceof NonNull) {
            return c;
        }
        return new NonNullImmutableMap<K, V>(c);
    }

    private NonNullCollections() {
    }
}

