/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.ssl;

import com.urbancode.commons.util.crypto.SecureRandomHelper;
import com.urbancode.commons.util.ssl.ClientAuthMode;
import com.urbancode.commons.util.ssl.ConfigurableSSLServerSocketFactory;
import com.urbancode.commons.util.ssl.ConfigurableSSLSocketFactory;
import com.urbancode.commons.util.ssl.OpenX509TrustManager;
import com.urbancode.commons.util.ssl.SSLContextProtocolDetector;
import com.urbancode.commons.util.ssl.SSLSocketConfig;
import com.urbancode.commons.util.ssl.StoredX509Cert;
import com.urbancode.commons.util.ssl.StoringX509TrustManager;
import com.urbancode.commons.util.ssl.X509CertStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;

public class SslSupport
implements X509CertStore {
    private static final Logger log = Logger.getLogger(SslSupport.class);
    private SSLContext sslContext;
    private KeyStore keyStore;
    private String sslContextProtocol;
    private boolean checkCertificates;
    private boolean storeUntrustedCertificates;
    private ClientAuthMode clientAuthMode;
    private String keyStorePassword;
    private String keyPassword;
    private File keyStoreFile;
    private Thread keyStoreCheckThread;
    private long keyStoreLastModified;
    private int keyStoreCheckSeconds;
    private List<SSLSocketConfig> socketConfigs = new ArrayList<SSLSocketConfig>();
    private final Set<StoredX509Cert> untrustedCertSet = new HashSet<StoredX509Cert>();

    public SslSupport() {
        this.sslContextProtocol = SSLContextProtocolDetector.detectSslContextProtocol();
        log.debug((Object)("Chose " + this.sslContextProtocol + " for SSLContext protocol."));
    }

    public synchronized ClientAuthMode getClientAuthMode() {
        return this.clientAuthMode;
    }

    public synchronized void setClientAuthMode(ClientAuthMode clientAuthMode) {
        this.assertNotInitialized();
        this.clientAuthMode = clientAuthMode;
    }

    public synchronized int getKeyStoreCheckSeconds() {
        return this.keyStoreCheckSeconds;
    }

    public synchronized void setKeyStoreCheckSeconds(int keyStoreCheckSeconds) {
        this.assertNotInitialized();
        this.keyStoreCheckSeconds = keyStoreCheckSeconds;
    }

    public synchronized boolean isCheckCertificates() {
        return this.checkCertificates;
    }

    public synchronized void setCheckCertificates(boolean checkCertificates) {
        this.assertNotInitialized();
        this.checkCertificates = checkCertificates;
    }

    public synchronized boolean isStoreUntrustedCertificates() {
        return this.storeUntrustedCertificates;
    }

    public synchronized void setStoreUntrustedCertificates(boolean storeUntrustedCertificates) {
        this.assertNotInitialized();
        this.storeUntrustedCertificates = storeUntrustedCertificates;
    }

    public synchronized String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public synchronized void setKeyStorePassword(String keyStorePassword) {
        this.assertNotInitialized();
        this.keyStorePassword = keyStorePassword;
    }

    public synchronized String getKeyPassword() {
        return this.keyPassword;
    }

    public synchronized void setKeyPassword(String keyPassword) {
        this.assertNotInitialized();
        this.keyPassword = keyPassword;
    }

    public synchronized File getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public synchronized void setKeyStoreFile(File keyStoreFile) {
        this.assertNotInitialized();
        this.keyStoreFile = keyStoreFile;
    }

    public synchronized String getSslContextProtocol() {
        return this.sslContextProtocol;
    }

    public synchronized void setSslContextProtocol(String sslContextProtocol) {
        this.assertNotInitialized();
        this.sslContextProtocol = sslContextProtocol;
    }

    public synchronized void addSocketConfig(SSLSocketConfig socketConfig) {
        this.assertNotInitialized();
        this.socketConfigs.add(socketConfig);
    }

    public synchronized SSLSocketFactory getSSLSocketFactory() throws GeneralSecurityException, IOException {
        this.initialize();
        SSLSocketFactory factory = this.getSSLContext().getSocketFactory();
        ConfigurableSSLSocketFactory configuredFactory = new ConfigurableSSLSocketFactory(factory);
        for (SSLSocketConfig config : this.socketConfigs) {
            configuredFactory.addSocketConfigurator(config);
        }
        return configuredFactory;
    }

    public synchronized SSLServerSocketFactory getSSLServerSocketFactory() throws GeneralSecurityException, IOException {
        this.initialize();
        SSLServerSocketFactory factory = this.getSSLContext().getServerSocketFactory();
        ConfigurableSSLServerSocketFactory configuredFactory = new ConfigurableSSLServerSocketFactory(factory);
        for (SSLSocketConfig config : this.socketConfigs) {
            configuredFactory.addSocketConfigurator(config);
        }
        if (this.clientAuthMode != null) {
            configuredFactory.addSocketConfigurator(this.clientAuthMode);
        }
        return configuredFactory;
    }

    public synchronized void initialize() throws GeneralSecurityException, IOException {
        if (!this.isInitialized()) {
            this.validateAtInitialization();
            this.loadKeyStore();
            if (this.keyStoreCheckSeconds > 0) {
                Runnable keyStoreCheckRunnable = new Runnable(){
                    private long sleepMS;
                    {
                        this.sleepMS = SslSupport.this.keyStoreCheckSeconds * 1000;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        while (true) {
                            try {
                                while (true) {
                                    Thread.sleep(this.sleepMS);
                                    SslSupport sslSupport = SslSupport.this;
                                    synchronized (sslSupport) {
                                        if (SslSupport.this.keyStoreFile.lastModified() > SslSupport.this.keyStoreLastModified) {
                                            log.info((Object)"Detected a changed to the SSL keystore, reloading the keystore");
                                            SslSupport.this.loadKeyStore();
                                        }
                                    }
                                }
                            }
                            catch (InterruptedException e) {
                                log.warn((Object)("SslSupport Keystore Monitor Error: " + e.toString()));
                                continue;
                            }
                            catch (GeneralSecurityException e) {
                                log.warn((Object)("SslSupport Keystore Monitor Error: " + e.toString()));
                                continue;
                            }
                            catch (IOException e) {
                                log.warn((Object)("SslSupport Keystore Monitor Error: " + e.toString()));
                                continue;
                            }
                            break;
                        }
                    }
                };
                this.keyStoreCheckThread = new Thread(null, keyStoreCheckRunnable, "SslSupport-KeyStoreMonitor");
                this.keyStoreCheckThread.setDaemon(true);
                this.keyStoreCheckThread.start();
            }
        }
    }

    public synchronized boolean isKeyPresent(String name) throws GeneralSecurityException, IOException {
        this.initialize();
        return this.keyStore.isKeyEntry(name);
    }

    private void loadKeyStore() throws GeneralSecurityException, IOException {
        this.keyStoreLastModified = this.keyStoreFile.lastModified();
        this.keyStore = this.newKeyStore();
        this.loadKeyStore(this.keyStore, this.keyStoreFile, this.keyStorePassword);
        KeyManager[] keyManagers = this.newKeyManagers(this.keyStore, this.keyPassword);
        TrustManager[] trustManagers = this.newTrustManagers(this.keyStore);
        SecureRandom random = SecureRandomHelper.getSecureRandom();
        if (this.sslContext == null) {
            this.sslContext = this.newSSLContext(keyManagers, trustManagers, random);
        } else {
            this.sslContext.init(keyManagers, trustManagers, random);
        }
    }

    private void validateAtInitialization() {
        if (this.clientAuthMode == null) {
            throw new IllegalStateException("clientAuthMode not set");
        }
        if (this.keyStorePassword == null) {
            throw new IllegalStateException("keyStorePassword not set");
        }
        if (this.keyPassword == null) {
            throw new IllegalStateException("keyPassword not set");
        }
        if (this.keyStoreFile == null) {
            throw new IllegalStateException("keyStoreFile not set");
        }
    }

    private SSLContext getSSLContext() {
        return this.sslContext;
    }

    private boolean isInitialized() {
        return this.getSSLContext() != null;
    }

    private void assertNotInitialized() {
        if (this.isInitialized()) {
            throw new IllegalStateException("already initialized");
        }
    }

    private KeyManager[] newKeyManagers(KeyStore store, String password) throws GeneralSecurityException {
        KeyManagerFactory keyManagerFactory = this.newKeyManagerFactory(store, password);
        return keyManagerFactory.getKeyManagers();
    }

    private TrustManager[] newTrustManagers(KeyStore store) throws KeyStoreException {
        TrustManager[] result;
        if (this.isCheckCertificates()) {
            TrustManagerFactory trustManagerFactory = this.newTrustManagerFactory();
            trustManagerFactory.init(store);
            result = trustManagerFactory.getTrustManagers();
        } else {
            result = this.newOpenTrustManagers();
        }
        if (this.isStoreUntrustedCertificates()) {
            result = StoringX509TrustManager.wrap(result, this);
        }
        return result;
    }

    private TrustManager[] newOpenTrustManagers() {
        return new TrustManager[]{new OpenX509TrustManager()};
    }

    private TrustManagerFactory newTrustManagerFactory() {
        String algorithm = TrustManagerFactory.getDefaultAlgorithm();
        try {
            return TrustManagerFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("The default trust manager algorithm is unavailable", e);
        }
    }

    private KeyManagerFactory newKeyManagerFactory(KeyStore store, String password) throws GeneralSecurityException {
        String algorithm = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory factory = KeyManagerFactory.getInstance(algorithm);
        factory.init(store, password.toCharArray());
        return factory;
    }

    private SSLContext newSSLContext(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom random) {
        try {
            SSLContext localSslContext = SSLContext.getInstance(this.sslContextProtocol);
            localSslContext.init(keyManagers, trustManagers, random);
            return localSslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SSL protocol \"" + this.sslContextProtocol + "\" is not available", e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeyStore(KeyStore keystore, File file, String password) throws GeneralSecurityException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            keystore.load(in, password.toCharArray());
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private KeyStore newKeyStore() {
        String type = "JKS";
        try {
            return KeyStore.getInstance(type);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Key store type \"" + type + "\" is not available", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(StoredX509Cert cert, boolean trusted) {
        if (!trusted) {
            Set<StoredX509Cert> set = this.untrustedCertSet;
            synchronized (set) {
                this.untrustedCertSet.add(cert);
            }
        }
    }

    @Override
    public StoredX509Cert[] getStoredTrustedCerts() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoredX509Cert[] getStoredUntrustedCerts() {
        StoredX509Cert[] certs = null;
        Set<StoredX509Cert> set = this.untrustedCertSet;
        synchronized (set) {
            certs = this.untrustedCertSet.toArray(new StoredX509Cert[this.untrustedCertSet.size()]);
        }
        return certs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUntrustedCert(StoredX509Cert cert) {
        Set<StoredX509Cert> set = this.untrustedCertSet;
        synchronized (set) {
            this.untrustedCertSet.remove(cert);
        }
    }

    @Override
    public synchronized void trustCert(StoredX509Cert storedCert, String alias) throws Exception {
        X509Certificate[] chain;
        log.info((Object)("Trusting cert " + storedCert + " as alias '" + alias + "'."));
        KeyStore keyStore = this.newKeyStore();
        this.loadKeyStore(keyStore, this.keyStoreFile, this.keyStorePassword);
        for (X509Certificate cert : chain = storedCert.getChain()) {
            keyStore.setCertificateEntry(alias, cert);
        }
        FileOutputStream keyStoreOut = null;
        try {
            log.info((Object)("Updating keystore '" + this.keyStoreFile + "'..."));
            keyStoreOut = new FileOutputStream(this.keyStoreFile);
            keyStore.store(keyStoreOut, this.keyStorePassword.toCharArray());
            this.removeUntrustedCert(storedCert);
            log.info((Object)("Reloading keystore '" + this.keyStoreFile + "'..."));
            this.loadKeyStore();
            log.info((Object)"Reloading keystore complete.");
        }
        catch (Exception e) {
            log.error((Object)"Error updating keystore with trusted certificate.", (Throwable)e);
            throw new KeyStoreException(e);
        }
    }
}

