/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.iterator.files;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.iterator.AbstractSentinelIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

final class EachFileAndDirectoryRecursivePPIterator
extends AbstractSentinelIterator<File> {
    private final List<File> directoryStack = new ArrayList<File>();
    private final Pattern filePattern;
    private final Pattern directoryPattern;
    private Iterator<File> currentDirectory;

    EachFileAndDirectoryRecursivePPIterator(File directory, Pattern fileNamePattern, Pattern directoryNamePattern) {
        this.currentDirectory = IO.listFiles(directory).iterator();
        this.filePattern = fileNamePattern;
        this.directoryPattern = directoryNamePattern;
    }

    @Override
    protected File nextItem() {
        File result = null;
        boolean done = false;
        while (!done) {
            if (!this.currentDirectory.hasNext()) {
                if (!this.directoryStack.isEmpty()) {
                    File directory = this.directoryStack.remove(this.directoryStack.size() - 1);
                    this.currentDirectory = IO.listFiles(directory).iterator();
                } else {
                    this.currentDirectory = Collections.emptyList().iterator();
                    done = true;
                }
            }
            while (!done && this.currentDirectory.hasNext()) {
                File file = this.currentDirectory.next();
                String name = file.getName();
                if (file.isFile() && this.filePattern.matcher(name).matches()) {
                    result = file;
                    done = true;
                    continue;
                }
                if (!file.isDirectory() || !this.directoryPattern.matcher(name).matches()) continue;
                this.directoryStack.add(file);
                result = file;
                done = true;
            }
        }
        return result;
    }
}

