/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.iterator.files;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.iterator.AbstractSentinelIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class EachFileRecursiveIterator
extends AbstractSentinelIterator<File> {
    private final List<File> directoryStack = new ArrayList<File>();
    private Iterator<File> currentDirectory;

    EachFileRecursiveIterator(File directory) {
        this.currentDirectory = IO.listFiles(directory).iterator();
    }

    @Override
    protected File nextItem() {
        File result = null;
        boolean done = false;
        while (!done) {
            if (!this.currentDirectory.hasNext()) {
                if (!this.directoryStack.isEmpty()) {
                    File directory = this.directoryStack.remove(this.directoryStack.size() - 1);
                    this.currentDirectory = IO.listFiles(directory).iterator();
                } else {
                    this.currentDirectory = Collections.emptyList().iterator();
                    done = true;
                }
            }
            while (!done && this.currentDirectory.hasNext()) {
                File file = this.currentDirectory.next();
                if (file.isFile()) {
                    result = file;
                    done = true;
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.directoryStack.add(file);
            }
        }
        return result;
    }
}

