/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool;

def apTool = new AirPluginTool(this.args[0], this.args[1]);

def props = apTool.getStepProperties();

String variable = props['variable'];
String value = props['value'];

String actualValue = System.getenv(variable);

println "Checking environment variable with name $variable"
if (actualValue == null) {
    throw new Exception("Environment Variable $variable is not set!");
}
else if (value != null && !value.equals("")) {
    if (!value.equals(actualValue)) {
        throw new Exception("Environment Variable $variable value does not match expected:" +
                            "$value != $actualValue");
    }
    else {
        println "The value for the environment variable $variable matches the expected $value";
    }
}
else {
    println "The value of the environment variable is set!";
}
