/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool;
import java.util.regex.Pattern;
import java.util.regex.Matcher;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();
def regex = props['regex'];
def value = props['valueString'];


Pattern pattern = Pattern.compile(regex);
Matcher matcher = pattern.matcher(value);

if (matcher.find()) {
    println "Found match : " + matcher.group(0);
    int numOfGroups = matcher.groupCount();
    for (int i = 0 ; i <= numOfGroups ; i++) {//matcher does not include the entire match as part of the group count
        String group = matcher.group(i);
        String propName = "group"+ i.toString();
        apTool.setOutputProperty(propName, group);
    }
}
else {
    throw new Exception("No match found for pattern $regex in value $value");
}

apTool.storeOutputProperties();
