/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.sandboxedjsruntime;

import java.util.HashSet;
import java.util.Set;
import org.mozilla.javascript.ClassShutter;

public class WhiteListClassShutter
implements ClassShutter {
    private static final Set<String> DEFAULT_WHITE_LIST = new HashSet<String>();
    private Set<String> whiteListClassNames = new HashSet<String>();
    private boolean allowDefaults = true;

    public boolean visibleToScripts(String fullClassName) {
        boolean result = false;
        if (this.allowDefaults) {
            result = DEFAULT_WHITE_LIST.contains(fullClassName);
        }
        result = result || this.whiteListClassNames.contains(fullClassName);
        return result;
    }

    public void allowDefaultClasses(boolean arg) {
        this.allowDefaults = arg;
    }

    public boolean add(String fullClassName) {
        return this.whiteListClassNames.add(fullClassName);
    }

    public boolean remove(String fullClassName) {
        return this.whiteListClassNames.remove(fullClassName);
    }

    static {
        DEFAULT_WHITE_LIST.add("java.util.Properties");
        DEFAULT_WHITE_LIST.add("java.util.LinkedHashMap");
        DEFAULT_WHITE_LIST.add("java.util.LinkedHashSet");
        DEFAULT_WHITE_LIST.add("java.lang.String");
        DEFAULT_WHITE_LIST.add("java.lang.Integer");
        DEFAULT_WHITE_LIST.add("java.lang.Long");
        DEFAULT_WHITE_LIST.add("java.lang.Double");
        DEFAULT_WHITE_LIST.add("java.lang.Float");
        DEFAULT_WHITE_LIST.add("java.lang.Number");
        DEFAULT_WHITE_LIST.add("java.lang.Boolean");
    }
}

