/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import org.apache.commons.io.FileSystemUtils;
import com.urbancode.air.AirPluginTool;

def apTool = new AirPluginTool(this.args[0], this.args[1]);

def props = apTool.getStepProperties();

def path = props['path'];
def min = Long.valueOf(props['size']);

println "Checking $path has at least $min kb of available disk space"
def freeSpace = FileSystemUtils.freeSpaceKb(path);

if (freeSpace < min) {
    throw new Exception("$freeSpace kb is less space than requested : $min kb");
}
else {
    println "$path has $freeSpace kb available";
}
