/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool;
import java.util.regex.Pattern;
import java.util.regex.Matcher;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();
def regex = props['regex'];
def value = props['valueString'];


Pattern pattern = Pattern.compile(regex);
Matcher matcher = pattern.matcher(value);

if (matcher.find()) {
    println "Found match : " + matcher.group(0);
    int numOfGroups = matcher.groupCount();
    for (int i = 0 ; i <= numOfGroups ; i++) {//matcher does not include the entire match as part of the group count
        String group = matcher.group(i);
        String propName = "group"+ i.toString();
        apTool.setOutputProperty(propName, group);
    }
}
else {
    throw new Exception("No match found for pattern $regex in value $value");
}

apTool.storeOutputProperties();
