/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.util.processes.Processes;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TfToolClient {
    private static final Logger log = Logger.getLogger(TfToolClient.class);
    private final String tfsVersion;
    private final String url;
    private final String username;
    private final String password;

    public TfToolClient(String tfsVersion, String url, String username, String password) throws IOException, Exception {
        this.tfsVersion = tfsVersion.equals("2013") ? "2012" : tfsVersion;
        this.url = url;
        this.username = StringUtil.trimToNull(username);
        this.password = password;
        if (!SystemUtils.IS_OS_WINDOWS) {
            throw new Exception("[error] The UCD TFS-SourceConfig plug-in requires Windows with .NET 3.5 installed.");
        }
    }

    public BuildInfo getLatestBuildInfo(String pluginHome, String projectName, String buildDefinition, String buildStatus, String buildQuality) throws Exception {
        BuildInfo result = null;
        ArrayList<String> command = new ArrayList<String>();
        command.add(pluginHome + "/tftool" + this.tfsVersion + ".exe");
        command.add("latestbuildinfo");
        command.add("/server:" + this.url);
        command.add("/projectName:" + projectName);
        command.add("/buildDefinition:" + buildDefinition);
        command.add("/buildStatus:" + buildStatus);
        if (StringUtil.trimToNull(buildQuality) != null) {
            command.add("/buildQuality:" + StringUtil.trimToNull(buildQuality));
        }
        if (this.username != null) {
            command.add("/user:" + this.username);
        }
        if (this.password != null) {
            command.add("/password:" + this.password);
        }
        System.out.println("Get Latest TFS build info for: \\\\" + projectName + "\\" + buildDefinition);
        this.logCommand(command, this.password);
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future<String> errorFuture = processes.getErrorStringFuture(process);
            BufferedReader inReader = IO.buffer(new InputStreamReader(process.getInputStream()));
            int status = process.waitFor();
            if (status == 2) {
                System.out.println("Did not find any builds with status " + buildStatus + " and quality " + (buildQuality == null ? "" : buildQuality));
            } else {
                if (status != 0) {
                    String line = inReader.readLine();
                    while (line != null) {
                        System.out.println(line);
                        line = inReader.readLine();
                    }
                    throw new IOException("Error retrieving latest build: " + errorFuture.get());
                }
                result = new BuildInfo();
                String line = inReader.readLine();
                int index = 0;
                while (line != null) {
                    if (log.isDebugEnabled()) {
                        System.out.println(line);
                    }
                    if (line.trim().length() > 0) {
                        if (index == 0) {
                            result.setArtifactLocation(line.trim());
                        } else if (index == 3) {
                            result.setVersion(this.extractVersion(line));
                        } else if (index == 4) {
                            result.setSourceChangeset(line.trim());
                        }
                    }
                    ++index;
                    line = inReader.readLine();
                }
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
        return result;
    }

    public BuildInfo getBuildInfoForBuildNumber(String pluginHome, String projectName, String buildDefinition, String buildNumber) throws Exception {
        BuildInfo result = null;
        ArrayList<String> command = new ArrayList<String>();
        command.add(pluginHome + "/tftool" + this.tfsVersion + ".exe");
        command.add("buildinfo");
        command.add("/server:" + this.url);
        command.add("/projectName:" + projectName);
        command.add("/buildDefinition:" + buildDefinition);
        command.add("/buildNumber:" + buildNumber);
        if (this.username != null) {
            command.add("/user:" + this.username);
        }
        if (this.password != null) {
            command.add("/password:" + this.password);
        }
        System.out.println("Get TFS build info for: " + buildNumber);
        this.logCommand(command, this.password);
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future<String> errorFuture = processes.getErrorStringFuture(process);
            BufferedReader inReader = IO.buffer(new InputStreamReader(process.getInputStream()));
            int status = process.waitFor();
            if (status == 2) {
                System.out.println("Did not find any builds for " + buildNumber);
            } else {
                if (status != 0) {
                    String line = inReader.readLine();
                    while (line != null) {
                        System.out.println(line);
                        line = inReader.readLine();
                    }
                    throw new IOException("Error retrieving build " + buildNumber + ": " + errorFuture.get());
                }
                result = new BuildInfo();
                String line = inReader.readLine();
                int index = 0;
                while (line != null) {
                    if (log.isDebugEnabled()) {
                        System.out.println(line);
                    }
                    if (line.trim().length() > 0) {
                        if (index == 0) {
                            result.setArtifactLocation(line.trim());
                        } else if (index == 3) {
                            result.setVersion(this.extractVersion(line));
                        } else if (index == 4) {
                            result.setSourceChangeset(line.trim());
                        }
                    }
                    line = inReader.readLine();
                    ++index;
                }
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
        return result;
    }

    public BuildInfo getSpecificBuildInfo(String pluginHome, String projectName, String buildDefinition, String buildUri) throws Exception {
        BuildInfo result = null;
        ArrayList<String> command = new ArrayList<String>();
        command.add(pluginHome + "/tftool" + this.tfsVersion + ".exe");
        command.add("buildinfo");
        command.add("/server:" + this.url);
        command.add("/buildUri:" + buildUri);
        if (this.username != null) {
            command.add("/user:" + this.username);
        }
        if (this.password != null) {
            command.add("/password:" + this.password);
        }
        System.out.println("Get TFS build info for: " + buildUri);
        this.logCommand(command, this.password);
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future<String> errorFuture = processes.getErrorStringFuture(process);
            BufferedReader inReader = IO.buffer(new InputStreamReader(process.getInputStream()));
            int status = process.waitFor();
            if (status != 0) {
                String line = inReader.readLine();
                while (line != null) {
                    System.out.println(line);
                    line = inReader.readLine();
                }
                throw new IOException("Error retrieving build: " + errorFuture.get());
            }
            result = new BuildInfo();
            String line = inReader.readLine();
            int index = 0;
            while (line != null) {
                if (log.isDebugEnabled()) {
                    System.out.println(line);
                }
                if (line.trim().length() > 0) {
                    if (index == 0) {
                        result.setArtifactLocation(line.trim());
                    } else if (index == 3) {
                        result.setVersion(this.extractVersion(line));
                    } else if (index == 4) {
                        result.setSourceChangeset(line.trim());
                    }
                }
                line = inReader.readLine();
                ++index;
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
        return result;
    }

    public void copyArtifacts(File workDir, String remotePath) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add("xcopy");
        command.add(remotePath.replaceAll("/", Matcher.quoteReplacement("\\")) + "\\*.*");
        command.add(".");
        command.add("/e");
        command.add("/h");
        command.add("/y");
        command.add("/z");
        System.out.println("Get TFS build files");
        this.logCommand(command, new String[0]);
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.directory(workDir);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future<String> errorFuture = processes.getErrorStringFuture(process);
            IO.copy(process.getInputStream(), IO.NULL);
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("Error retrieving build artifacts: " + errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
    }

    private void logCommand(List<String> command, String ... secureValues) {
        if (log.isDebugEnabled()) {
            String s = StringUtil.join(command.toArray(new String[0]), " ");
            if (secureValues != null) {
                for (String secureValue : secureValues) {
                    if (secureValue == null || secureValue.trim().length() <= 0) continue;
                    s = s.replace(secureValue, "*****");
                }
            }
            System.out.println(s);
        }
    }

    private String extractVersion(String line) {
        String result = null;
        if (line != null && line.trim().length() > 0) {
            Pattern pattern;
            Matcher matcher;
            result = line.trim();
            if (line.lastIndexOf("@$/") != -1) {
                result = line.substring(0, line.lastIndexOf("@$/")).trim();
            }
            if ((matcher = (pattern = Pattern.compile("_(\\d{8}\\.\\d+)")).matcher(result)).find()) {
                result = matcher.group(1);
            }
        }
        if (log.isDebugEnabled()) {
            System.out.println("Detected version: " + result);
        }
        return result;
    }

    public class BuildInfo {
        private String version;
        private String artifactLocation;
        private String sourceChangeset;

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getArtifactLocation() {
            return this.artifactLocation;
        }

        public void setArtifactLocation(String artifactLocation) {
            this.artifactLocation = artifactLocation;
        }

        public String getSourceChangeset() {
            return this.sourceChangeset;
        }

        public void setSourceChangeset(String sourceChangeset) {
            this.sourceChangeset = sourceChangeset;
        }
    }
}

