/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class TFSFactory {
    public static TFSTeamProjectCollection createTFSCollection(String tfsPassword, String tfsUrl, String tfsUserName) {
        URI tfsURI = TFSFactory.createURI(tfsUrl);
        UsernamePasswordCredentials tfsCreds = TFSFactory.getTFSCredentials(tfsPassword, tfsUserName);
        TFSTeamProjectCollection result = new TFSTeamProjectCollection(tfsURI, (Credentials)tfsCreds);
        result.authenticate();
        return result;
    }

    private static URI createURI(String tfsUrl) {
        URI result = null;
        URL tfsUrlValidated = null;
        String tfsURLTrimmed = tfsUrl.trim();
        try {
            tfsUrlValidated = new URL(tfsURLTrimmed);
        }
        catch (MalformedURLException e) {
            System.out.println("Cannot initialize URL. " + e.getMessage());
            System.exit(1);
        }
        String path = tfsUrlValidated.getPath();
        try {
            result = new URI(tfsUrlValidated.getProtocol(), null, tfsUrlValidated.getHost(), tfsUrlValidated.getPort(), path, null, null);
        }
        catch (URISyntaxException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        return result;
    }

    private static UsernamePasswordCredentials getTFSCredentials(String tfsPassword, String tfsUserName) {
        String tfsUserNameTrimmed = tfsUserName.trim();
        UsernamePasswordCredentials result = new UsernamePasswordCredentials(tfsUserNameTrimmed, tfsPassword);
        return result;
    }
}

