/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.build.IBuildDefinition;
import com.microsoft.tfs.core.clients.build.IBuildDefinitionSpec;
import com.microsoft.tfs.core.clients.build.IBuildDetail;
import com.microsoft.tfs.core.clients.build.IBuildDetailSpec;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.IFailure;
import com.microsoft.tfs.core.clients.build.flags.BuildQueryOrder;
import com.microsoft.tfs.core.clients.build.flags.BuildStatus;
import com.microsoft.tfs.core.clients.build.flags.QueryOptions;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ProjectCollectionEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.TeamProjectEntity;
import com.urbancode.air.plugin.command.TFSFactory;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.util.processes.Processes;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.SystemUtils;

public class TfToolClient {
    private final String url;
    private final String username;
    private final String password;

    public TfToolClient(String url, String username, String password) throws IOException, Exception {
        this.url = url;
        this.username = StringUtil.trimToNull(username);
        this.password = password;
        if (!SystemUtils.IS_OS_WINDOWS) {
            throw new Exception("[error] The UCD TFS-SourceConfig plug-in requires Windows with .NET 3.5 installed.");
        }
    }

    public BuildInfo getLatestBuildInfo(String pluginHome, String projectName, String buildDefinition, String buildStatus, String buildQuality) throws Exception {
        BuildInfo result = new BuildInfo();
        System.setProperty("com.microsoft.tfs.jni.native.base-directory", pluginHome + "/lib/native");
        TFSTeamProjectCollection tfsCollection = TFSFactory.createTFSCollection(this.password, this.url, this.username);
        ProjectCollectionEntity pce = tfsCollection.getTeamProjectCollectionEntity(true);
        TeamProjectEntity[] tpe = pce.getTeamProjects();
        System.out.println("Found " + tpe.length + " team project(s).");
        for (TeamProjectEntity t : tpe) {
            System.out.println("Project: " + t.getProjectName());
        }
        IBuildServer buildServer = tfsCollection.getBuildServer();
        System.out.println("TFS Supported? " + this.isTFSVersionSupported(buildServer));
        System.out.println("[Ok] Build Server Version: " + buildServer.getBuildServerVersion());
        IBuildDefinitionSpec s = buildServer.createBuildDefinitionSpec(tpe[0].getProjectName());
        IBuildDefinition[] buildDefinitions = buildServer.queryBuildDefinitions(s).getDefinitions();
        IFailure[] failures = buildServer.queryBuildDefinitions(s).getFailures();
        System.out.println("Found " + failures.length + " failure(s).");
        for (IFailure iFailure : failures) {
            System.out.println("[Error] Failure: " + iFailure.getCode() + " - " + iFailure.getMessage());
        }
        System.out.println("Found " + buildDefinitions.length + " build definition(s).");
        for (IFailure iFailure : buildDefinitions) {
            this.displayBuildDefinitionProperties((IBuildDefinition)iFailure);
        }
        IBuildDetailSpec spec = buildServer.createBuildDetailSpec(projectName, buildDefinition);
        spec.setInformationTypes(null);
        spec.setMaxBuildsPerDefinition(1);
        spec.setQueryOrder(BuildQueryOrder.FINISH_TIME_DESCENDING);
        spec.setQueryOptions(QueryOptions.ALL);
        if (StringUtil.trimToNull(buildQuality) != null) {
            spec.setQuality(buildQuality);
        }
        if (buildStatus.equals("ALL")) {
            spec.setStatus(BuildStatus.ALL);
        } else if (buildStatus.equals("SUCCEEDED")) {
            spec.setStatus(BuildStatus.SUCCEEDED);
        } else if (buildStatus.equals("PARTIALLY_SUCCEEDED")) {
            spec.setStatus(BuildStatus.SUCCEEDED);
        } else if (buildStatus.equals("PARTIALLY_SUCCEEDED")) {
            spec.setStatus(BuildStatus.SUCCEEDED);
        } else if (buildStatus.equals("NONE")) {
            spec.setStatus(BuildStatus.NONE);
        } else if (buildStatus.equals("FAILED")) {
            spec.setStatus(BuildStatus.FAILED);
        } else if (buildStatus.equals("STOPPED")) {
            spec.setStatus(BuildStatus.STOPPED);
        } else if (buildStatus.equals("NOT_STARTED")) {
            spec.setStatus(BuildStatus.NOT_STARTED);
        }
        IBuildDetail[] latestBuild = buildServer.queryBuilds(spec).getBuilds();
        if (latestBuild.length != 0) {
            result.setSourceChangeset(latestBuild[0].getSourceGetVersion());
            result.setArtifactLocation(latestBuild[0].getDropLocation());
            result.setVersion(latestBuild[0].getBuildNumber());
        } else {
            System.out.println("[Warning] No builds found with `" + buildStatus + "` status.");
            System.out.println("[Info] Only XAML builds are supported by the TFS Source Config. XAML builds have been deprecated by Microsoft since TFS 2015.");
            System.out.println("\tPlease use the VSTS plug-in for newer build types.");
            System.out.println("");
        }
        return result;
    }

    public BuildInfo getBuildInfoForBuildNumber(String pluginHome, String projectName, String buildDefinition, String buildNumber) throws Exception {
        BuildInfo result = new BuildInfo();
        System.setProperty("com.microsoft.tfs.jni.native.base-directory", pluginHome + "/lib/native");
        TFSTeamProjectCollection tfsCollection = TFSFactory.createTFSCollection(this.password, this.url, this.username);
        IBuildServer buildServer = tfsCollection.getBuildServer();
        IBuildDetailSpec spec = buildServer.createBuildDetailSpec(projectName, buildDefinition);
        spec.setBuildNumber(buildNumber);
        spec.setInformationTypes(null);
        spec.setMaxBuildsPerDefinition(1);
        spec.setQueryOrder(BuildQueryOrder.FINISH_TIME_ASCENDING);
        spec.setQueryOptions(QueryOptions.ALL);
        IBuildDetail[] buildByNumber = buildServer.queryBuilds(spec).getBuilds();
        if (buildByNumber.length != 0) {
            result.setSourceChangeset(buildByNumber[0].getSourceGetVersion());
            result.setArtifactLocation(buildByNumber[0].getDropLocation());
            result.setVersion(buildByNumber[0].getBuildNumber());
        } else {
            System.out.println("[Warning] No builds found with `" + buildNumber + "` build number.");
            System.out.println("");
        }
        return result;
    }

    public BuildInfo getSpecificBuildInfo(String pluginHome, String projectName, String buildDefinition, String buildUri) throws Exception {
        BuildInfo result = new BuildInfo();
        String[] uri = new String[]{buildUri};
        System.setProperty("com.microsoft.tfs.jni.native.base-directory", pluginHome + "/lib/native");
        TFSTeamProjectCollection tfsCollection = TFSFactory.createTFSCollection(this.password, this.url, this.username);
        IBuildServer buildServer = tfsCollection.getBuildServer();
        IBuildDetailSpec spec = buildServer.createBuildDetailSpec(projectName, buildDefinition);
        spec.setInformationTypes(null);
        spec.setMaxBuildsPerDefinition(1);
        spec.setQueryOrder(BuildQueryOrder.FINISH_TIME_ASCENDING);
        spec.setQueryOptions(QueryOptions.ALL);
        IBuildDetail[] buildByURI = buildServer.queryBuildsByURI(uri, null, QueryOptions.ALL);
        if (buildByURI.length != 0) {
            result.setSourceChangeset(buildByURI[0].getSourceGetVersion());
            result.setArtifactLocation(buildByURI[0].getDropLocation());
            result.setVersion(buildByURI[0].getBuildNumber());
        } else {
            System.out.println("[Warning] No builds found with `" + buildUri + "` build URI.");
            System.out.println("");
        }
        return result;
    }

    public void copyArtifacts(File workDir, String remotePath) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add("xcopy");
        command.add(remotePath.replaceAll("/", Matcher.quoteReplacement("\\")) + "\\*.*");
        command.add(".");
        command.add("/e");
        command.add("/h");
        command.add("/y");
        command.add("/z");
        System.out.println("Get TFS build files");
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.directory(workDir);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future<String> errorFuture = processes.getErrorStringFuture(process);
            IO.copy(process.getInputStream(), IO.NULL);
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("Error retrieving build artifacts: " + errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
    }

    private String extractVersion(String line) {
        String result = null;
        if (line != null && line.trim().length() > 0) {
            Pattern pattern;
            Matcher matcher;
            result = line.trim();
            if (line.lastIndexOf("@$/") != -1) {
                result = line.substring(0, line.lastIndexOf("@$/")).trim();
            }
            if ((matcher = (pattern = Pattern.compile("_(\\d{8}\\.\\d+)")).matcher(result)).find()) {
                result = matcher.group(1);
            }
        }
        System.out.println("Detected version: " + result);
        return result;
    }

    public boolean isTFSVersionSupported(IBuildServer buildServer) {
        if (buildServer.getBuildServerVersion().isLessThanV3()) {
            System.out.println("This plugin does not support TFS servers older than TFS 2010");
            return false;
        }
        return true;
    }

    public void displayBuildDefinitionProperties(IBuildDefinition buildDefinition) {
        System.out.println("Build Definition");
        System.out.println("\tName: " + buildDefinition.getName());
        System.out.println("\tURI: " + buildDefinition.getURI());
        System.out.println("\tDescription: " + buildDefinition.getDescription());
        System.out.println("\tEnabled: " + buildDefinition.isEnabled());
        System.out.println("\tDrop Folder: " + buildDefinition.getDefaultDropLocation());
        System.out.println("");
    }

    public class BuildInfo {
        private String version;
        private String artifactLocation;
        private String sourceChangeset;

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getArtifactLocation() {
            return this.artifactLocation;
        }

        public void setArtifactLocation(String artifactLocation) {
            this.artifactLocation = artifactLocation;
        }

        public String getSourceChangeset() {
            return this.sourceChangeset;
        }

        public void setSourceChangeset(String sourceChangeset) {
            this.sourceChangeset = sourceChangeset;
        }
    }
}

