/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.concurrent;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.Exceptions;
import com.urbancode.commons.util.concurrent.AtomicStartSupport;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;

public abstract class ServiceThread
extends Thread {
    private final AtomicStartSupport atomicStartSupport = new AtomicStartSupport();
    private final CountDownLatch shutdownLatch;

    public ServiceThread(String name, CountDownLatch shutdownLatch) {
        super(name);
        this.shutdownLatch = Check.nonNull(shutdownLatch, "shutdownLatch");
    }

    @Override
    public void start() {
        this.atomicStartSupport.assertNotStartedAndSetStarted();
        this.prestart();
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Logger log = this.getLogger();
        try {
            if (log.isDebugEnabled()) {
                log.debug("Started thread " + this.getName());
            }
            this.doRun();
        }
        catch (Throwable t) {
            if (!Exceptions.isCauseInterruption(t)) {
                log.error("Failure in thread " + this.getName(), t);
            }
        }
        finally {
            this.shutdownLatch.countDown();
            if (log.isDebugEnabled()) {
                log.debug("Thread " + this.getName() + " shutdown complete");
            }
        }
    }

    public boolean isStarted() {
        return this.atomicStartSupport.isStarted();
    }

    protected void prestart() {
    }

    protected void assertNotStarted() {
        this.atomicStartSupport.assertNotStarted();
    }

    protected void assertStarted() {
        this.atomicStartSupport.assertStarted();
    }

    protected abstract void doRun() throws Exception;

    protected abstract Logger getLogger();
}

