/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.filelister;

import com.urbancode.commons.fileutils.filelister.FileMatcher;
import com.urbancode.commons.util.FileFilterToRegex;
import com.urbancode.commons.util.iterator.files.Files;
import com.urbancode.commons.util.logging.LogUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FileFilterToRegexFileMatcher
implements FileMatcher {
    private static final Logger log = Logger.getLogger(FileFilterToRegexFileMatcher.class);
    private final File base;
    private final List<String> matches = new ArrayList<String>();

    public FileFilterToRegexFileMatcher(File base, Collection<String> includes, Collection<String> excludes) {
        this.base = base;
        ArrayList<Pattern> includePatterns = new ArrayList<Pattern>();
        for (String p : includes) {
            if (FileFilterToRegex.isMatchAll(p)) {
                includePatterns.clear();
                break;
            }
            Pattern pattern = FileFilterToRegex.convert(p);
            includePatterns.add(pattern);
            LogUtil.logTrace(log, String.format("Translated include %s to %s", p, pattern));
        }
        ArrayList<Pattern> excludePatterns = new ArrayList<Pattern>();
        for (String p : excludes) {
            Pattern pattern = FileFilterToRegex.convert(p);
            excludePatterns.add(pattern);
            LogUtil.logTrace(log, String.format("Translated exclude %s to %s", p, pattern));
        }
        HashSet<String> tentativeMatches = new HashSet<String>();
        block2: for (File file : Files.eachFileAndDirectoryRecursive(base)) {
            String path = this.relativize(file);
            if (log.isDebugEnabled()) {
                log.debug("Matching path " + path);
            }
            if (includePatterns.isEmpty()) {
                tentativeMatches.add(path);
                if (log.isDebugEnabled()) {
                    log.debug("Tentatively accepting " + path);
                }
            }
            for (Pattern pattern : includePatterns) {
                if (!pattern.matcher(path).matches()) continue;
                tentativeMatches.add(path);
                if (!log.isDebugEnabled()) continue block2;
                log.debug("Tentatively accepting " + path);
                continue block2;
            }
        }
        for (String path : tentativeMatches) {
            boolean keep = true;
            for (Pattern pattern : excludePatterns) {
                if (!pattern.matcher(path).matches()) continue;
                keep = false;
                break;
            }
            if (keep) {
                this.matches.add(path);
                if (!log.isDebugEnabled()) continue;
                log.debug("Keeping path " + path);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Discarding path " + path);
        }
    }

    @Override
    public Iterable<String> matches() {
        return this.matches;
    }

    @Override
    public File getBase() {
        return this.base;
    }

    private String relativize(File file) {
        boolean separatorLength = true;
        int basePathLength = this.base.getPath().length() + 1;
        if (this.base.getPath().equals("/") || this.base.getPath().endsWith(":\\") && this.base.getPath().length() == 3) {
            --basePathLength;
        }
        return file.getPath().substring(basePathLength).replace('\\', '/');
    }
}

