/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.processes;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.concurrent.AbstractNamedCallable;
import com.urbancode.commons.util.concurrent.NamedCallable;
import com.urbancode.commons.util.concurrent.NamedThreadFactory;
import com.urbancode.commons.util.concurrent.NonPoolingExecutorService;
import com.urbancode.commons.util.concurrent.WaitFuture;
import com.urbancode.commons.util.lazy.LazyFinalReference;
import com.urbancode.commons.util.lazy.PreComputedLazyFinalReference;
import com.urbancode.commons.util.lazy.RacyLazyFinalReference;
import com.urbancode.commons.util.processes.ProcessException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public final class Processes {
    private static final Logger log = Logger.getLogger(Processes.class);
    static final String DISABLE_SHARED_POOL_KEY = "com.urbancode.commons.util.processes.Processes.disableSharedPool";
    private final LazyFinalReference<ExecutorService> pool;

    public Processes() {
        this((LazyFinalReference<ExecutorService>)new RacyLazyFinalReference<ExecutorService>(){

            @Override
            protected ExecutorService initialValue() {
                return SharedPoolInitializer.sharedPool;
            }
        });
    }

    public Processes(ExecutorService pool) {
        this(new PreComputedLazyFinalReference<ExecutorService>(Check.nonNull(pool, "pool")));
    }

    public Processes(LazyFinalReference<ExecutorService> pool) {
        Check.nonNull(pool, "pool");
        this.pool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAndDiscardOutput(ProcessBuilder builder) throws IOException {
        String command = builder.command().get(0);
        if (log.isDebugEnabled()) {
            log.debug("Executing command " + command);
        }
        Process process = builder.start();
        boolean ok = false;
        try {
            WaitFuture future = this.discardOutput(process);
            String error = this.getErrorString(process).trim();
            try {
                try {
                    future.await();
                }
                catch (ExecutionException e) {
                    throw (IOException)new IOException("Error reading output").initCause(e);
                }
                int exitCode = process.waitFor();
                ok = true;
                if (log.isDebugEnabled()) {
                    log.debug("Command " + command + " completed with exit code " + exitCode);
                }
                if (exitCode != 0) {
                    throw new ProcessException(exitCode, error);
                }
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException(e.getMessage()).initCause(e);
            }
        }
        finally {
            if (!ok) {
                try {
                    process.destroy();
                }
                catch (Throwable swallow) {}
            }
        }
    }

    @WithBridgeMethods(value={void.class})
    public WaitFuture discardOutput(Process process) {
        return this.discard(process.getInputStream(), "discard-output");
    }

    @WithBridgeMethods(value={void.class})
    public WaitFuture discardError(Process process) {
        return this.discard(process.getErrorStream(), "discard-error");
    }

    @WithBridgeMethods(value={void.class})
    public WaitFuture redirectOutput(Process process, OutputStream out) {
        return this.redirect(process.getInputStream(), out, "redirect-output");
    }

    @WithBridgeMethods(value={void.class})
    public WaitFuture redirectError(Process process, OutputStream out) {
        return this.redirect(process.getErrorStream(), out, "redirect-error");
    }

    public String getOutputString(Process process) throws IOException {
        return this.getOutputString(process, null);
    }

    public String getOutputString(Process process, Charset charset) throws IOException {
        return IO.readText(IO.reader(process.getInputStream(), charset));
    }

    public String getErrorString(Process process) throws IOException {
        return this.getErrorString(process, null);
    }

    public String getErrorString(Process process, Charset charset) throws IOException {
        return IO.readText(IO.reader(process.getErrorStream(), charset));
    }

    public Future<String> getOutputStringFuture(Process process) {
        return this.getOutputStringFuture(process, null);
    }

    public Future<String> getOutputStringFuture(Process process, Charset charset) {
        InputStream in = process.getInputStream();
        return this.getStringFuture(in, charset, "get-output-string");
    }

    public Future<String> getErrorStringFuture(Process process) {
        return this.getErrorStringFuture(process, null);
    }

    public Future<String> getErrorStringFuture(Process process, Charset charset) {
        InputStream in = process.getErrorStream();
        return this.getStringFuture(in, charset, "get-error-string");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WaitFuture discard(final InputStream in, String name) {
        WaitFuture result;
        boolean ok = false;
        try {
            result = new WaitFuture(this.submit(new AbstractNamedCallable<Void>(name){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws IOException {
                    try {
                        try {
                            IO.copy(in, IO.NULL);
                        }
                        finally {
                            IO.closeNoThrow(in);
                        }
                        Void void_ = null;
                        return void_;
                    }
                    finally {
                        if (log.isDebugEnabled()) {
                            log.debug("Job " + this.getName() + " completed");
                        }
                    }
                }
            }));
            ok = true;
        }
        finally {
            if (!ok) {
                IO.closeNoThrow(in);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WaitFuture redirect(final InputStream in, final OutputStream out, String name) {
        WaitFuture result;
        boolean ok = false;
        try {
            result = new WaitFuture(this.submit(new AbstractNamedCallable<Void>(name){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws IOException {
                    Thread thread = Thread.currentThread();
                    String name = thread.getName();
                    try {
                        Void void_;
                        thread.setName(name + ": " + this.getName());
                        try {
                            try {
                                IO.copy(in, out);
                            }
                            finally {
                                IO.closeNoThrow(in);
                            }
                            void_ = null;
                        }
                        catch (Throwable throwable) {
                            if (log.isDebugEnabled()) {
                                log.debug("Job " + this.getName() + " completed");
                            }
                            throw throwable;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Job " + this.getName() + " completed");
                        }
                        return void_;
                    }
                    finally {
                        thread.setName(name);
                    }
                }
            }));
            ok = true;
        }
        finally {
            if (!ok) {
                IO.closeNoThrow(in);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<String> getStringFuture(final InputStream in, final Charset charset, String name) {
        Future<String> result;
        boolean ok = false;
        try {
            result = this.submit(new AbstractNamedCallable<String>(name){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String call() throws IOException {
                    try {
                        String string = IO.readText(IO.reader(in, charset));
                        return string;
                    }
                    finally {
                        if (log.isDebugEnabled()) {
                            log.debug("Job " + this.getName() + " completed");
                        }
                    }
                }
            });
            ok = true;
        }
        finally {
            if (!ok) {
                IO.closeNoThrow(in);
            }
        }
        return result;
    }

    private <T> Future<T> submit(Callable<T> callable) {
        if (log.isDebugEnabled()) {
            if (callable instanceof NamedCallable) {
                NamedCallable named = (NamedCallable)callable;
                log.debug("Submitting job " + named.getName() + " to thread pool");
            } else {
                log.debug("Submitting job to thread pool");
            }
        }
        return this.pool.get().submit(callable);
    }

    @BridgeMethodsAdded
    private static final class SharedPoolInitializer {
        static final ExecutorService sharedPool;

        private SharedPoolInitializer() {
        }

        static {
            NamedThreadFactory factory = new NamedThreadFactory("Processes.sharedPool", NamedThreadFactory.ThreadMode.DAEMON);
            if (Boolean.getBoolean(Processes.DISABLE_SHARED_POOL_KEY)) {
                if (log.isDebugEnabled()) {
                    log.debug("Creating non-pooling shared thread \"pool\"");
                }
                sharedPool = new NonPoolingExecutorService(factory);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Creating shared thread pool");
                }
                sharedPool = Executors.newCachedThreadPool(factory);
            }
        }
    }
}

