/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.TfToolClient;
import com.urbancode.commons.util.IO;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class ImportVersion {
    private Properties inputProperties;
    private Properties outputProperties;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        int returnCode = 0;
        File repoDir = null;
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/log4j.properties")));
            PropertyConfigurator.configure((Properties)props);
            Properties agentProps = new Properties();
            agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
            String charsetName = agentProps.getProperty("system.default.encoding");
            String extensionString = this.inputProperties.getProperty("extensions");
            String[] extensions = new String[]{};
            if (extensionString != null) {
                extensions = extensionString.split(",");
                for (int i = 0; i < extensions.length; ++i) {
                    extensions[i] = extensions[i].trim();
                }
            }
            Charset charset = null;
            if (charsetName != null) {
                charset = Charset.forName(charsetName);
            }
            String componentName = this.inputProperties.getProperty("componentName");
            String repoUrl = this.inputProperties.getProperty("url");
            String tfsVersion = this.inputProperties.getProperty("tfsVersion");
            String tfsUsername = this.inputProperties.getProperty("user");
            String tfsPassword = this.inputProperties.getProperty("password");
            String tfsTeamProject = this.inputProperties.getProperty("project");
            String[] buildDefinitions = this.splitLines(this.inputProperties.getProperty("buildDefinition"));
            boolean prependBuildDefinition = Boolean.valueOf(this.inputProperties.getProperty("prependBuildDefinition"));
            String buildStatus = this.inputProperties.getProperty("buildStatus");
            String buildQuality = this.inputProperties.getProperty("buildQuality");
            String dirOffset = this.inputProperties.getProperty("dirOffset");
            String[] includes = this.splitLines(this.inputProperties.getProperty("includes"));
            String pluginHome = System.getenv("PLUGIN_HOME");
            if (includes.length == 0) {
                includes = new String[]{"**/*"};
            }
            String[] excludes = this.splitLines(this.inputProperties.getProperty("excludes"));
            String buildNumber = this.inputProperties.getProperty("buildNumber");
            String buildUri = this.inputProperties.getProperty("buildURI");
            boolean isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
            String username = "PasswordIsAuthToken";
            String password = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
            String webUrl = System.getenv("AH_WEB_URL");
            URI url = new URI(webUrl);
            VersionClient versionClient = new VersionClient(url, username, password);
            ComponentClient componentClient = new ComponentClient(url, username, password);
            TfToolClient client = new TfToolClient(tfsVersion, repoUrl, tfsUsername, tfsPassword);
            for (int i = 0; i < buildDefinitions.length; ++i) {
                String buildDefinition = buildDefinitions[i];
                TfToolClient.BuildInfo buildInfo = null;
                buildInfo = buildUri != null && buildUri.length() > 0 ? client.getSpecificBuildInfo(pluginHome, tfsTeamProject, buildDefinition, buildUri) : (buildNumber != null && buildNumber.length() > 0 ? client.getBuildInfoForBuildNumber(pluginHome, tfsTeamProject, buildDefinition, buildNumber) : client.getLatestBuildInfo(pluginHome, tfsTeamProject, buildDefinition, buildStatus, buildQuality));
                if (buildInfo == null) {
                    System.out.println("No build found in TFS!");
                    continue;
                }
                if (buildInfo.getVersion() == null || buildInfo.getVersion().trim().length() == 0) {
                    throw new Exception("Could not get a build version from TFS!");
                }
                List versions = componentClient.getComponentVersions(componentName, Boolean.valueOf(false));
                boolean hasVersion = versions.contains(buildInfo.getVersion());
                if (!hasVersion) {
                    String versionName = buildInfo.getVersion();
                    if (prependBuildDefinition) {
                        versionName = buildDefinition + "-" + versionName;
                    }
                    String versionId = versionClient.createVersion(componentName, versionName, " ").toString();
                    this.outputProperties.setProperty("VersionID", versionId);
                    if (isUseVFS) {
                        File tempDir = File.createTempFile("tfs-build-", "-tmp");
                        tempDir.delete();
                        try {
                            if (!tempDir.mkdirs()) {
                                throw new IOException("Could not create temporary dir " + tempDir.getAbsolutePath());
                            }
                            String artifactLocation = buildInfo.getArtifactLocation();
                            if (!artifactLocation.endsWith("\\")) {
                                artifactLocation = artifactLocation + "\\";
                            }
                            if (dirOffset != null) {
                                artifactLocation = artifactLocation + dirOffset;
                            }
                            while (artifactLocation.endsWith("\\")) {
                                artifactLocation = artifactLocation.substring(0, artifactLocation.length() - 1);
                            }
                            client.copyArtifacts(tempDir, artifactLocation);
                            System.out.println("Uploading artifact files.");
                            versionClient.addVersionFiles(componentName, versionId, tempDir, "", includes, excludes, false, true, charset, extensions);
                        }
                        catch (Throwable throwable) {
                            try {
                                IO.delete((File)tempDir);
                            }
                            catch (IOException e) {
                                System.err.println(String.format("Unable to delete download directory", e));
                            }
                            throw throwable;
                        }
                        try {
                            IO.delete((File)tempDir);
                        }
                        catch (IOException e) {
                            System.err.println(String.format("Unable to delete download directory", e));
                        }
                        continue;
                    }
                    System.out.println("Skipping Artifact Upload: Component is configured not to use codestation.");
                    continue;
                }
                System.out.println(String.format("Component Already Has Version: %s", buildInfo.getVersion()));
            }
        }
        catch (Exception e) {
            System.err.println(String.format("Error Initializing New Version: %s", e.getMessage()));
            e.printStackTrace();
            returnCode = 1;
        }
        finally {
            if (repoDir != null && repoDir.exists()) {
                repoDir.delete();
            }
        }
        return returnCode;
    }

    private String[] splitLines(String string) {
        ArrayList<String> lines = new ArrayList<String>();
        if (string != null) {
            BufferedReader in = IO.buffer((Reader)IO.reader((String)string));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    lines.add(line);
                }
            }
            catch (IOException impossible) {
                throw new RuntimeException(impossible);
            }
        }
        return lines.toArray(new String[lines.size()]);
    }
}

