/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.TfToolClient;
import com.urbancode.commons.util.IO;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class ImportVersion {
    private boolean isUseVFS;
    private Charset charset;
    private String password;
    private String pluginHome;
    private String username;
    private URI url;
    private String componentName;
    private String repoUrl;
    private String tfsVersion;
    private String tfsUsername;
    private String tfsPassword;
    private String tfsTeamProject;
    private String[] buildDefinitions;
    private boolean prependBuildDefinition;
    private String buildStatus;
    private String buildQuality;
    private String dirOffset;
    private String[] includes;
    private String[] excludes;
    private String buildNumber;
    private String buildUri;
    private String[] extensions;
    private String buildDefinitionSpecific;
    private VersionClient versionClient;
    private ComponentClient componentClient;
    private TfToolClient client;
    int returnCode = 0;
    Properties inputProperties;
    Properties outputProperties;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        int returnCode = 0;
        File repoDir = null;
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/log4j.properties")));
            PropertyConfigurator.configure((Properties)props);
            Properties agentProps = new Properties();
            agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
            String charsetName = agentProps.getProperty("system.default.encoding");
            this.charset = null;
            if (charsetName != null) {
                this.charset = Charset.forName(charsetName);
            }
            this.pluginHome = System.getenv("PLUGIN_HOME");
            this.username = "PasswordIsAuthToken";
            this.password = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
            String webUrl = System.getenv("AH_WEB_URL");
            this.url = new URI(webUrl);
            this.isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
            this.componentName = this.inputProperties.getProperty("componentName");
            this.repoUrl = this.inputProperties.getProperty("url");
            this.tfsVersion = this.inputProperties.getProperty("tfsVersion");
            this.tfsUsername = this.inputProperties.getProperty("user");
            this.tfsPassword = this.inputProperties.getProperty("password");
            this.tfsTeamProject = this.inputProperties.getProperty("project");
            this.buildDefinitions = this.splitLines(this.inputProperties.getProperty("buildDefinition"));
            this.prependBuildDefinition = Boolean.valueOf(this.inputProperties.getProperty("prependBuildDefinition"));
            this.buildStatus = this.inputProperties.getProperty("buildStatus");
            this.buildQuality = this.inputProperties.getProperty("buildQuality");
            this.dirOffset = this.inputProperties.getProperty("dirOffset");
            this.includes = this.splitLines(this.inputProperties.getProperty("includes"));
            if (this.includes.length == 0) {
                this.includes = new String[]{"**/*"};
            }
            this.excludes = this.splitLines(this.inputProperties.getProperty("excludes"));
            this.buildNumber = this.inputProperties.getProperty("buildNumber", "");
            this.buildUri = this.inputProperties.getProperty("buildURI", "");
            String extensionString = this.inputProperties.getProperty("extensions");
            this.extensions = new String[0];
            if (extensionString != null) {
                this.extensions = extensionString.split(",");
                for (int i = 0; i < this.extensions.length; ++i) {
                    this.extensions[i] = this.extensions[i].trim();
                }
            }
            this.buildDefinitionSpecific = this.inputProperties.getProperty("buildDefinitionSpecific", "").trim();
            boolean buildDefinitionExists = false;
            if (this.buildDefinitionSpecific != null && !this.buildDefinitionSpecific.isEmpty()) {
                for (int i = 0; i < this.buildDefinitions.length; ++i) {
                    if (!this.buildDefinitionSpecific.equals(this.buildDefinitions[i])) continue;
                    buildDefinitionExists = true;
                }
                if (!buildDefinitionExists) {
                    throw new Exception("The build definition specified at import does not match any of the build definitions specified in the basic component settings.");
                }
            } else if (!(this.buildUri.isEmpty() && this.buildNumber.isEmpty() || this.buildDefinitions.length <= 1)) {
                throw new Exception("[error] As you have specified multiple build defintions you must input the Build Definition property at the prompt along with the Build ID or Build URI properties. If you specifiy it by itself it will pull the latest build from that definition macthing the status criteria.");
            }
            this.versionClient = new VersionClient(this.url, this.username, this.password);
            this.componentClient = new ComponentClient(this.url, this.username, this.password);
            this.client = new TfToolClient(this.tfsVersion, this.repoUrl, this.tfsUsername, this.tfsPassword);
            TfToolClient.BuildInfo buildInfo = null;
            if (this.buildUri != null && !this.buildUri.isEmpty() && buildDefinitionExists) {
                buildInfo = this.client.getSpecificBuildInfo(this.pluginHome, this.tfsTeamProject, this.buildDefinitionSpecific, this.buildUri);
                this.pushArtifact(buildInfo, this.buildDefinitionSpecific);
            } else if (this.buildNumber != null && !this.buildNumber.isEmpty() && buildDefinitionExists) {
                buildInfo = this.client.getBuildInfoForBuildNumber(this.pluginHome, this.tfsTeamProject, this.buildDefinitionSpecific, this.buildNumber);
                this.pushArtifact(buildInfo, this.buildDefinitionSpecific);
            } else if (buildDefinitionExists) {
                buildInfo = this.client.getLatestBuildInfo(this.pluginHome, this.tfsTeamProject, this.buildDefinitionSpecific, this.buildStatus, this.buildQuality);
                this.pushArtifact(buildInfo, this.buildDefinitionSpecific);
            } else {
                for (int i = 0; i < this.buildDefinitions.length; ++i) {
                    String buildDefinition = this.buildDefinitions[i];
                    buildInfo = this.client.getLatestBuildInfo(this.pluginHome, this.tfsTeamProject, buildDefinition, this.buildStatus, this.buildQuality);
                    this.pushArtifact(buildInfo, buildDefinition);
                }
            }
        }
        catch (Exception e) {
            System.err.println(String.format("Error Initializing New Version: %s", e.getMessage()));
            e.printStackTrace();
            returnCode = 1;
        }
        finally {
            if (repoDir != null && repoDir.exists()) {
                repoDir.delete();
            }
        }
        return returnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushArtifact(TfToolClient.BuildInfo buildInfo, String buildDefinition) throws Exception, IOException {
        block13: {
            block14: {
                block15: {
                    boolean hasVersion;
                    block12: {
                        if (buildInfo != null) break block12;
                        System.out.println("No build found in TFS!");
                        break block13;
                    }
                    if (buildInfo.getVersion() == null || buildInfo.getVersion().trim().isEmpty()) {
                        throw new Exception("Could not get a build version from TFS!");
                    }
                    List versions = this.componentClient.getComponentVersions(this.componentName, Boolean.valueOf(false));
                    String versionName = buildInfo.getVersion();
                    if (this.prependBuildDefinition) {
                        versionName = buildDefinition + "-" + versionName;
                    }
                    if (hasVersion = versions.contains(versionName)) break block14;
                    String versionId = this.versionClient.createVersion(this.componentName, versionName, " ").toString();
                    this.outputProperties.setProperty("VersionID", versionId);
                    if (!this.isUseVFS) break block15;
                    File tempDir = File.createTempFile("tfs-build-", "-tmp");
                    tempDir.delete();
                    try {
                        if (!tempDir.mkdirs()) {
                            throw new IOException("Could not create temporary dir " + tempDir.getAbsolutePath());
                        }
                        String artifactLocation = buildInfo.getArtifactLocation();
                        if (!artifactLocation.endsWith("\\")) {
                            artifactLocation = artifactLocation + "\\";
                        }
                        if (this.dirOffset != null) {
                            artifactLocation = artifactLocation + this.dirOffset;
                        }
                        while (artifactLocation.endsWith("\\")) {
                            artifactLocation = artifactLocation.substring(0, artifactLocation.length() - 1);
                        }
                        this.client.copyArtifacts(tempDir, artifactLocation);
                        System.out.println("Uploading artifact files.");
                        this.versionClient.addVersionFiles(this.componentName, versionId, tempDir, "", this.includes, this.excludes, false, true, this.charset, this.extensions);
                    }
                    catch (Throwable throwable) {
                        try {
                            IO.delete((File)tempDir);
                        }
                        catch (IOException e) {
                            System.err.println(String.format("Unable to delete download directory", e));
                        }
                        throw throwable;
                    }
                    try {
                        IO.delete((File)tempDir);
                    }
                    catch (IOException e) {
                        System.err.println(String.format("Unable to delete download directory", e));
                    }
                    break block13;
                }
                System.out.println("Skipping Artifact Upload: Component is configured not to use codestation.");
                break block13;
            }
            System.out.println(String.format("Component Already Has Version: %s", buildInfo.getVersion()));
        }
    }

    private String[] splitLines(String string) {
        ArrayList<String> lines = new ArrayList<String>();
        if (string != null) {
            BufferedReader in = IO.buffer((Reader)IO.reader((String)string));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    lines.add(line);
                }
            }
            catch (IOException impossible) {
                throw new RuntimeException(impossible);
            }
        }
        return lines.toArray(new String[lines.size()]);
    }
}

