/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.httpcomponentsutil;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ApplySSLSocketFactory
implements HttpRequestInterceptor {
    private final Registry<ConnectionSocketFactory> registry;

    static Registry<ConnectionSocketFactory> buildSocketFactoryRegistry(SSLConnectionSocketFactory sslSocketFactory) {
        return RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sslSocketFactory)).build();
    }

    public ApplySSLSocketFactory(SSLConnectionSocketFactory sslSocketFactory) {
        this(ApplySSLSocketFactory.buildSocketFactoryRegistry(sslSocketFactory));
    }

    public ApplySSLSocketFactory(Registry<ConnectionSocketFactory> registry) {
        this.registry = registry;
        this.registry.getClass();
    }

    @Override
    public void process(HttpRequest request, HttpContext oldContext) throws HttpException, IOException {
        HttpClientContext context = HttpClientContext.adapt(oldContext);
        if (context.getAttribute("http.socket-factory-registry") == null) {
            context.setAttribute("http.socket-factory-registry", this.registry);
        }
    }
}

