/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.ssl;

import com.urbancode.commons.util.logging.LogUtil;
import com.urbancode.commons.util.ssl.ConfigurableSSLServerSocketFactory;
import com.urbancode.commons.util.ssl.ConfigurableSSLSocketFactory;
import com.urbancode.commons.util.ssl.SSLConfiguratorDefaultPolicy;
import com.urbancode.commons.util.ssl.SSLConfiguratorPolicy;
import com.urbancode.commons.util.ssl.SSLSocketConfig;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;

public class SSLConfigurator {
    public static final String POLICY_CLASS_PROPERTY = "SSLConfigurator.policyClass";
    private static final Logger log = Logger.getLogger(SSLConfigurator.class);
    SSLContext context;
    SSLSocketFactory socketFactory;
    SSLServerSocketFactory serverSocketFactory;
    SSLSocketConfig config;
    SSLConfiguratorPolicy policy;
    private String[] serverProtocols = null;

    private static SSLContext init(SSLContext context) throws KeyManagementException {
        context.init(null, null, null);
        return context;
    }

    public SSLConfigurator() throws IOException, NoSuchAlgorithmException, KeyManagementException {
        this(SSLConfigurator.init(SSLContext.getInstance("TLS")));
    }

    public SSLConfigurator(SSLContext context) throws IOException {
        this.context = context;
        this.config = new SSLSocketConfig(){

            @Override
            public void configure(SSLSocket socket) {
                String[] supportedProtos = socket.getSupportedProtocols();
                String[] enabledProtos = SSLConfigurator.this.policy.enabledProtocols(supportedProtos, false);
                socket.setEnabledProtocols(enabledProtos);
                String[] supportedCiphers = socket.getSupportedCipherSuites();
                String[] enabledCiphers = SSLConfigurator.this.policy.enabledCipherSuites(supportedCiphers);
                socket.setEnabledCipherSuites(enabledCiphers);
            }

            @Override
            public void configure(SSLServerSocket socket) {
                String[] supportedProtos = socket.getSupportedProtocols();
                String[] enabledProtos = SSLConfigurator.this.policy.enabledProtocols(supportedProtos, true);
                socket.setEnabledProtocols(enabledProtos);
                String[] supportedCiphers = socket.getSupportedCipherSuites();
                String[] enabledCiphers = SSLConfigurator.this.policy.enabledCipherSuites(supportedCiphers);
                socket.setEnabledCipherSuites(enabledCiphers);
            }
        };
        this.socketFactory = this.wrap(context.getSocketFactory());
        this.serverSocketFactory = this.wrap(context.getServerSocketFactory());
        String policyClassName = System.getProperty(POLICY_CLASS_PROPERTY);
        if (policyClassName != null) {
            try {
                this.policy = (SSLConfiguratorPolicy)Class.forName(policyClassName).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create policy instance " + policyClassName + ": " + e.toString(), e);
            }
        } else {
            this.policy = new SSLConfiguratorDefaultPolicy();
        }
        if (LogUtil.isTraceEnabled(log)) {
            Object[] serverSupportedProtos = this.initSupportedServerProtocols();
            Object[] clientSupportedProtos = this.getContext().createSSLEngine().getSupportedProtocols();
            Object[] serverSupportedCipherSuites = context.getServerSocketFactory().getSupportedCipherSuites();
            Object[] clientSupportedCipherSuites = context.getSocketFactory().getSupportedCipherSuites();
            LogUtil.logTrace(log, "Server Supported Protocols: " + Arrays.toString(serverSupportedProtos));
            LogUtil.logTrace(log, "Server Enabled Protocols: " + Arrays.toString(this.getEnabledServerProtocols()));
            LogUtil.logTrace(log, "Client Supported Protocols: " + Arrays.toString(clientSupportedProtos));
            LogUtil.logTrace(log, "Client Enabled Protocols: " + Arrays.toString(this.getEnabledClientProtocols()));
            LogUtil.logTrace(log, "Server Supported CipherSuites: " + Arrays.toString(serverSupportedCipherSuites));
            LogUtil.logTrace(log, "Server Enabled CipherSuites: " + Arrays.toString(this.getEnabledServerCiphers()));
            LogUtil.logTrace(log, "Client Supported CipherSuites: " + Arrays.toString(clientSupportedCipherSuites));
            LogUtil.logTrace(log, "Client Enabled CipherSuites: " + Arrays.toString(this.getEnabledClientCiphers()));
        }
    }

    public SSLContext getContext() {
        return this.context;
    }

    public SSLSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public SSLServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    public SSLSocketFactory wrap(SSLSocketFactory socketFactory) {
        ConfigurableSSLSocketFactory cSocketFactory = new ConfigurableSSLSocketFactory(socketFactory);
        cSocketFactory.addSocketConfigurator(this.config);
        return cSocketFactory;
    }

    public SSLServerSocketFactory wrap(SSLServerSocketFactory socketFactory) {
        ConfigurableSSLServerSocketFactory cSocketFactory = new ConfigurableSSLServerSocketFactory(socketFactory);
        cSocketFactory.addSocketConfigurator(this.config);
        return cSocketFactory;
    }

    public void configure(SSLEngine engine) {
        String[] supportedProtos = engine.getSupportedProtocols();
        String[] enabledProtos = this.policy.enabledProtocols(supportedProtos, true);
        engine.setEnabledProtocols(enabledProtos);
        String[] supportedCiphers = engine.getSupportedCipherSuites();
        String[] enabledCiphers = this.policy.enabledCipherSuites(supportedCiphers);
        engine.setEnabledCipherSuites(enabledCiphers);
    }

    public void configure(SSLSocket socket) {
        this.config.configure(socket);
    }

    public void configure(SSLServerSocket socket) {
        this.config.configure(socket);
    }

    public String[] getEnabledServerProtocols() throws IOException {
        String[] supportedProtos = this.initSupportedServerProtocols();
        return this.policy.enabledProtocols(supportedProtos, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] initSupportedServerProtocols() throws IOException {
        if (this.serverProtocols == null) {
            SSLConfigurator sSLConfigurator = this;
            synchronized (sSLConfigurator) {
                if (this.serverProtocols == null) {
                    SSLServerSocket sock = (SSLServerSocket)this.getServerSocketFactory().createServerSocket(0);
                    try {
                        this.serverProtocols = sock.getSupportedProtocols();
                    }
                    finally {
                        sock.close();
                    }
                }
            }
        }
        return this.serverProtocols;
    }

    public String[] getEnabledClientProtocols() throws IOException {
        String[] protos;
        SSLEngine engine = this.getContext().createSSLEngine();
        try {
            protos = engine.getSupportedProtocols();
        }
        finally {
            engine.closeInbound();
            engine.closeOutbound();
        }
        return this.policy.enabledProtocols(protos, false);
    }

    public String[] getEnabledServerCiphers() {
        String[] supportedCipherSuites = this.getServerSocketFactory().getSupportedCipherSuites();
        return this.policy.enabledCipherSuites(supportedCipherSuites);
    }

    public String[] getEnabledClientCiphers() {
        String[] supportedCipherSuites = this.getSocketFactory().getSupportedCipherSuites();
        return this.policy.enabledCipherSuites(supportedCipherSuites);
    }
}

