/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamPumper {
    private static final int SIZE = 4096;

    public static void pump(InputStream is, OutputStream os) throws IOException {
        boolean shouldWrite = os != null;
        byte[] buf = new byte[4096];
        int length = 0;
        while ((length = is.read(buf)) > 0) {
            if (!shouldWrite) continue;
            os.write(buf, 0, length);
        }
        if (shouldWrite) {
            os.flush();
        }
    }

    public static void pumpWithBufferSize(InputStream is, OutputStream os, int bufSize) throws IOException {
        boolean shouldWrite = os != null;
        byte[] buf = new byte[bufSize];
        int length = 0;
        while ((length = is.read(buf)) > 0) {
            if (!shouldWrite) continue;
            os.write(buf, 0, length);
        }
        if (shouldWrite && (length = is.read(buf)) > 0) {
            os.write(buf, 0, length);
        }
        if (shouldWrite) {
            os.flush();
        }
    }

    public static void pump(InputStream is, OutputStream os, long bytesToRead) throws IOException {
        boolean shouldWrite = os != null;
        byte[] buf = new byte[4096];
        int length = 0;
        long bytesRead = 0L;
        while (bytesRead < bytesToRead) {
            if (bytesToRead - bytesRead > 4096L) {
                length = is.read(buf);
                bytesRead += (long)length;
            } else {
                length = is.read(buf, 0, (int)(bytesToRead - bytesRead));
                bytesRead += (long)length;
            }
            if (length <= 0) break;
            if (!shouldWrite) continue;
            os.write(buf, 0, length);
        }
        if (bytesRead < bytesToRead) {
            if (bytesToRead - bytesRead > 4096L) {
                length = is.read(buf);
                bytesRead += (long)length;
            } else {
                length = is.read(buf, 0, (int)(bytesToRead - bytesRead));
                bytesRead += (long)length;
            }
            if (length > 0 && shouldWrite) {
                os.write(buf, 0, length);
            }
        }
        if (shouldWrite) {
            os.flush();
        }
    }

    private StreamPumper() {
    }
}

