/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.io;

import com.urbancode.commons.io.StreamBuffer;
import java.io.IOException;
import java.io.InputStream;

public class BufferInputStream
extends InputStream {
    public static final int END_OF_FILE = -1;
    private StreamBuffer buffer = null;
    private boolean isClosed = false;

    public BufferInputStream(StreamBuffer buffer) {
        this.buffer = buffer;
    }

    public synchronized int read() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed");
        }
        return this.buffer.read();
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed");
        }
        return this.buffer.read(b, off, len);
    }

    public synchronized int available() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed");
        }
        return this.buffer.available();
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readAheadLimit) {
    }

    public synchronized void reset() {
    }

    public synchronized void close() throws IOException {
        this.isClosed = true;
    }
}

