/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.filter.csrf;

import com.urbancode.commons.web.filter.csrf.Whitelist;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class WhitelistBuilder {
    private final Pattern comment = Pattern.compile("^\\s*#.*$");
    private final Pattern include = Pattern.compile("^\\s*\\+\\s+(.*)$");
    private final Pattern exclude = Pattern.compile("^\\s*-\\s+(.*)$");

    WhitelistBuilder() {
    }

    public Whitelist build(BufferedReader in) throws IOException {
        String line;
        ArrayList<Pattern> includes = new ArrayList<Pattern>();
        ArrayList<Pattern> excludes = new ArrayList<Pattern>();
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || this.comment.matcher(line).matches()) continue;
            Matcher im = this.include.matcher(line);
            if (im.matches()) {
                Pattern p;
                try {
                    p = Pattern.compile(im.group(1).trim());
                }
                catch (PatternSyntaxException e) {
                    throw new IOException("Invalid include pattern: " + line);
                }
                includes.add(p);
                continue;
            }
            Matcher em = this.exclude.matcher(line);
            if (em.matches()) {
                Pattern p;
                try {
                    p = Pattern.compile(em.group(1).trim());
                }
                catch (PatternSyntaxException e) {
                    throw new IOException("Invalid include pattern: " + line);
                }
                excludes.add(p);
                continue;
            }
            throw new IOException("Invalid syntax: " + line);
        }
        return new Whitelist(includes, excludes);
    }
}

