/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.filter.csrf;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.web.filter.csrf.Whitelist;
import com.urbancode.commons.web.filter.csrf.WhitelistBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CsrfFilter
implements Filter {
    private static final Logger log = Logger.getLogger(CsrfFilter.class);
    private static final boolean disabled = Boolean.getBoolean("com.urbancode.commons.web.filter.csrf.CsrfFilter.disabled") || Boolean.getBoolean("com.urbancode.anthill3.web.csrf.CsrfFilter.disabled") || Boolean.getBoolean("com.urbancode.ubuild.web.csrf.CsrfFilter.disabled");
    public static final String ALLOWED_ORIGIN_PROP = "com.urbancode.commons.web.filter.csrf.CsrfFilter.allowedOrigins";
    private static final List<URI> allowedOrigins;
    Whitelist whitelist;
    String csrfErrorPage;

    public void init(FilterConfig config) throws ServletException {
        if (!disabled) {
            this.csrfErrorPage = config.getInitParameter("errorPage");
            if (this.csrfErrorPage == null) {
                throw new ServletException("CSRF filter init: no errorPage specified");
            }
            this.csrfErrorPage = this.csrfErrorPage.trim();
            if (this.csrfErrorPage.isEmpty()) {
                throw new ServletException("CSRF filter init: empty errorPage specified");
            }
            String whitelistStr = config.getInitParameter("whitelist");
            if (whitelistStr == null) {
                throw new ServletException("CSRF filter init: no whitelist");
            }
            WhitelistBuilder builder = new WhitelistBuilder();
            try {
                this.whitelist = builder.build(IO.buffer(IO.reader(whitelistStr)));
            }
            catch (IOException e) {
                throw new ServletException("CSRF filter init: invalid whitelist", (Throwable)e);
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean accepted = true;
        if (!disabled && request instanceof HttpServletRequest) {
            String proxyHost;
            boolean proxied;
            String referer;
            String path;
            HttpServletRequest httpRequest;
            block16: {
                httpRequest = (HttpServletRequest)request;
                path = httpRequest.getRequestURI();
                referer = httpRequest.getHeader("Referer");
                proxied = false;
                proxyHost = null;
                accepted = this.whitelist.isAccepted(path);
                if (!accepted && referer != null) {
                    try {
                        URI refererUri = new URI(referer);
                        URI requestUri = new URI(httpRequest.getRequestURL().toString());
                        String forwardHost = httpRequest.getHeader("X-Forwarded-Host");
                        if (StringUtils.isNotEmpty(forwardHost)) {
                            proxied = true;
                            proxyHost = requestUri.getHost();
                            String forwardProto = httpRequest.getHeader("X-Forwarded-Proto");
                            if (forwardProto == null) {
                                forwardProto = refererUri.getScheme();
                            }
                            int refererPort = refererUri.getPort();
                            String forwardPort = httpRequest.getHeader("X-Forwarded-Port");
                            if (forwardPort != null) {
                                try {
                                    refererPort = Integer.valueOf(forwardPort);
                                }
                                catch (NumberFormatException e) {
                                    // empty catch block
                                }
                            }
                            requestUri = this.replaceHost(requestUri, forwardProto, forwardHost, refererPort);
                        }
                        if (accepted = this.isSameOrigin(requestUri, refererUri)) break block16;
                        for (URI allowedOrigin : allowedOrigins) {
                            if (!accepted) {
                                accepted = this.isSameOrigin(allowedOrigin, refererUri);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (URISyntaxException e) {
                        log.error("Unable to parse request or referer URIs", e);
                        accepted = false;
                    }
                }
            }
            if (!accepted) {
                if (referer == null) {
                    referer = "none";
                }
                if (proxyHost == null) {
                    proxyHost = "none";
                }
                log.warn(String.format("Possible CSRF attack:%n  path=%s%n  referer=%s%n  proxied=%s%n  proxyHost=%s", path, referer, proxied, proxyHost));
                StringBuilder uri = new StringBuilder();
                uri.append(request.getScheme());
                uri.append("://");
                uri.append(request.getServerName());
                uri.append(":");
                uri.append(httpRequest.getServerPort());
                String baseUri = uri.toString() + httpRequest.getContextPath();
                uri.append(httpRequest.getRequestURI());
                if (StringUtils.isNotEmpty(httpRequest.getQueryString())) {
                    uri.append("?");
                    uri.append(httpRequest.getQueryString());
                }
                request.setAttribute("baseUri", (Object)baseUri);
                request.setAttribute("requestedUri", (Object)uri.toString());
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.setStatus(403, "Possible CSRF attack");
                request.getRequestDispatcher(this.csrfErrorPage).forward(request, response);
            }
        }
        if (accepted) {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private boolean isSameOrigin(URI x, URI y) {
        String xScheme = this.toLowerCase(x.getScheme());
        String xHost = this.toLowerCase(x.getHost());
        int xPort = this.getPort(x);
        String yScheme = this.toLowerCase(y.getScheme());
        String yHost = this.toLowerCase(y.getHost());
        int yPort = this.getPort(y);
        return this.equals(xScheme, yScheme) && this.equals(xHost, yHost) && xPort == yPort;
    }

    private String toLowerCase(String s) {
        return s == null ? s : s.toLowerCase(Locale.US);
    }

    private boolean equals(Object x, Object y) {
        return x == y || x != null && x.equals(y);
    }

    private int getPort(URI u) {
        int result = u.getPort();
        if (result == -1) {
            String scheme = this.toLowerCase(u.getScheme());
            if ("http".equals(scheme)) {
                result = 80;
            } else if ("https".equals(scheme)) {
                result = 443;
            }
        }
        return result;
    }

    private URI replaceHost(URI u, String protocol, String host, int port) throws URISyntaxException {
        if (protocol == null) {
            protocol = u.getScheme();
        }
        if (port == -1) {
            port = u.getPort();
        }
        return new URI(protocol, null, host, port, null, null, null);
    }

    static {
        String allowedOriginProp = System.getProperty(ALLOWED_ORIGIN_PROP);
        ArrayList<URI> allowedOriginList = new ArrayList<URI>();
        if (allowedOriginProp != null && !allowedOriginProp.isEmpty()) {
            for (String token : allowedOriginProp.split("[,\\s]+")) {
                if ((token = token.trim()).isEmpty()) continue;
                try {
                    URI element = new URI(token);
                    allowedOriginList.add(element);
                }
                catch (URISyntaxException e) {
                    log.warn("Could not parse allowed origin from " + token, e);
                }
            }
        }
        allowedOrigins = Collections.unmodifiableList(allowedOriginList);
    }
}

