/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.util.processes.Processes;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TfsSourceClient {
    private static final Logger log = Logger.getLogger(TfsSourceClient.class);
    private final String tfExePath;
    private final String url;
    private final String username;
    private final String password;

    private static boolean pathContainsExecutable(String path) {
        return path != null && (path.toLowerCase().endsWith("tf") || path.toLowerCase().endsWith("tf.exe") || path.toLowerCase().endsWith("tf.cmd"));
    }

    public TfsSourceClient(String tfExePath, String url, String username, String password) throws IOException {
        this.tfExePath = TfsSourceClient.pathContainsExecutable(tfExePath) ? tfExePath : tfExePath + "\\tf.exe";
        this.url = url;
        this.username = StringUtil.trimToNull((String)username);
        this.password = StringUtil.trimToNull((String)password);
    }

    public boolean workspaceExists(String workspace) throws IOException {
        boolean workspaceExists = false;
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.tfExePath);
        command.add("workspaces");
        command.add("/server:" + this.url);
        command.add("/format:brief");
        if (this.username != null && this.password != null) {
            command.add("/login:" + this.username + "," + this.password);
        }
        log.info((Object)("Checking for the existence of TFS workspace: " + workspace));
        this.logCommand(command, this.password);
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future errorFuture = processes.getErrorStringFuture(process);
            BufferedReader outputReader = IO.buffer((Reader)IO.reader((InputStream)process.getInputStream()));
            boolean inWorkspaceList = false;
            String line = null;
            while ((line = outputReader.readLine()) != null) {
                if (line.startsWith("---------")) {
                    inWorkspaceList = true;
                    continue;
                }
                if (!inWorkspaceList || !line.startsWith(workspace + " ")) continue;
                inWorkspaceList = false;
                workspaceExists = true;
            }
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("TFS Get Workspaces Error: " + (String)errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
        log.info((Object)("TFS workspace '" + workspace + "' exists: " + workspaceExists));
        return workspaceExists;
    }

    public void createWorkspace(String workspace) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.tfExePath);
        command.add("workspace");
        command.add("/new");
        command.add("/noprompt");
        command.add("/server:" + this.url);
        if (this.username != null && this.password != null) {
            command.add("/login:" + this.username + "," + this.password);
        }
        command.add(workspace);
        log.info((Object)("Creating TFS workspace: " + workspace));
        this.logCommand(command, this.password);
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future errorFuture = processes.getErrorStringFuture(process);
            IO.copy((InputStream)process.getInputStream(), (OutputStream)IO.NULL);
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("TFS Create Workspace Error: " + (String)errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
    }

    public void deleteWorkspace(String workspace) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.tfExePath);
        command.add("workspace");
        command.add("/delete");
        if (this.username != null && this.password != null) {
            command.add("/login:" + this.username + "," + this.password);
        }
        command.add(workspace);
        log.info((Object)("Deleting TFS workspace: " + workspace));
        this.logCommand(command, this.password);
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future errorFuture = processes.getErrorStringFuture(process);
            IO.copy((InputStream)process.getInputStream(), (OutputStream)IO.NULL);
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("TFS Create Workspace Error: " + (String)errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
    }

    public void mapWorkspace(String workspace, String serverFolder, String localFolder) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.tfExePath);
        command.add("workfold");
        command.add("/map");
        command.add("/server:" + this.url);
        if (this.username != null && this.password != null) {
            command.add("/login:" + this.username + "," + this.password);
        }
        command.add("/workspace:" + workspace);
        command.add(serverFolder);
        command.add(localFolder);
        log.info((Object)("Mapping TFS workspace '" + workspace + "' to content '" + serverFolder + "' at '" + localFolder + "'"));
        this.logCommand(command, this.password);
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future errorFuture = processes.getErrorStringFuture(process);
            IO.copy((InputStream)process.getInputStream(), (OutputStream)IO.NULL);
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("TFS Map Workspace Error: " + (String)errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
    }

    protected void get(String serverFolder, String localFolder, boolean force, String versionSpec) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.tfExePath);
        command.add("get");
        command.add("/noprompt");
        command.add("/recursive");
        if (force) {
            command.add("/force");
        }
        if (this.username != null && this.password != null) {
            command.add("/login:" + this.username + "," + this.password);
        }
        command.add("/version:" + versionSpec);
        command.add(serverFolder);
        log.info((Object)("Getting TFS content: " + serverFolder));
        this.logCommand(command, this.password);
        File execDir = new File(localFolder);
        execDir.mkdirs();
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.directory(execDir);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future errorFuture = processes.getErrorStringFuture(process);
            IO.copy((InputStream)process.getInputStream(), (OutputStream)IO.NULL);
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("TFS Get Error: " + (String)errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
    }

    public String getLatestVersionName(String serverFolder, String localFolder) throws IOException {
        String result = null;
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.tfExePath);
        command.add("history");
        command.add("/noprompt");
        command.add("/recursive");
        command.add("/server:" + this.url);
        if (this.username != null && this.password != null) {
            command.add("/login:" + this.username + "," + this.password);
        }
        command.add("/version:T");
        command.add(serverFolder);
        log.info((Object)("Getting TFS history: " + serverFolder));
        this.logCommand(command, this.password);
        File execDir = new File(localFolder);
        execDir.mkdirs();
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.directory(execDir);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            String line;
            Future errorFuture = processes.getErrorStringFuture(process);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            boolean found = false;
            while ((line = reader.readLine()) != null) {
                Pattern pattern;
                Matcher matcher;
                if (found || !(matcher = (pattern = Pattern.compile("^([0-9]+).*")).matcher(line)).matches()) continue;
                result = matcher.group(1);
                found = true;
            }
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("TFS history Error: " + (String)errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
        return result;
    }

    public String getLatest(String serverFolder, String localFolder, boolean force) throws IOException {
        String versionName = this.getLatestVersionName(serverFolder, localFolder);
        this.get(serverFolder, localFolder, force, "T");
        return versionName;
    }

    public void getChangeset(String serverFolder, String localFolder, boolean force, String changeset) throws IOException {
        if (StringUtil.isEmpty((String)changeset)) {
            throw new IllegalArgumentException("TFS changeset value is required.");
        }
        this.get(serverFolder, localFolder, force, "C" + changeset);
    }

    public void getLabel(String serverFolder, String localFolder, boolean force, String label) throws IOException {
        if (StringUtil.isEmpty((String)label)) {
            throw new IllegalArgumentException("TFS label value is required.");
        }
        this.get(serverFolder, localFolder, force, "L" + label);
    }

    private void logCommand(List<String> command, String ... secureValues) {
        if (log.isDebugEnabled()) {
            String s = StringUtil.join((String[])command.toArray(new String[0]), (String)" ");
            if (secureValues != null) {
                for (String secureValue : secureValues) {
                    s = s.replace(secureValue, "*****");
                }
            }
            log.debug((Object)s);
        }
    }
}

