/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.TfsSourceClient;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.PropertyConfigurator;

public class ImportVersion {
    private Properties inputProperties;
    private Properties outputProperties;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int execute() {
        int returnCode;
        block38: {
            Exception e222;
            String workspace;
            File newLocalFolder;
            boolean workspaceCreated;
            TfsSourceClient client;
            File tempDir;
            block35: {
                returnCode = 0;
                tempDir = null;
                client = null;
                workspaceCreated = false;
                newLocalFolder = null;
                workspace = null;
                try {
                    block34: {
                        String udVersionName;
                        Properties props = new Properties();
                        props.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/log4j.properties")));
                        PropertyConfigurator.configure((Properties)props);
                        Properties agentProps = new Properties();
                        agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
                        String charsetName = agentProps.getProperty("system.default.encoding");
                        String extensionString = this.inputProperties.getProperty("extensions");
                        String[] extensions = new String[]{};
                        if (extensionString != null) {
                            extensions = extensionString.split(",");
                            for (int i = 0; i < extensions.length; ++i) {
                                extensions[i] = extensions[i].trim();
                            }
                        }
                        Charset charset = null;
                        if (charsetName != null) {
                            charset = Charset.forName(charsetName);
                        }
                        String componentName = this.inputProperties.getProperty("componentName");
                        String repoUrl = this.inputProperties.getProperty("url");
                        String tfsUsername = this.inputProperties.getProperty("username");
                        String tfsPassword = this.inputProperties.getProperty("password");
                        String exePath = this.inputProperties.getProperty("tfExePath");
                        workspace = this.inputProperties.getProperty("workspace");
                        String serverFolder = this.inputProperties.getProperty("serverFolder");
                        String localFolder = this.inputProperties.getProperty("localFolder");
                        String label = this.inputProperties.getProperty("label");
                        String changeSet = this.inputProperties.getProperty("changeSet");
                        boolean saveExecutePermissions = Boolean.valueOf(this.inputProperties.getProperty("saveFileExecuteBits"));
                        boolean isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
                        String[] includes = new String[]{"**/*"};
                        String[] excludes = new String[]{};
                        if (workspace == null || workspace.isEmpty()) {
                            workspace = "tfs-scm-plugin-workspace-" + UUID.randomUUID().toString();
                            System.out.println("[Info] `Workspace` property is empty. Generating temporary Workspace: " + workspace);
                            newLocalFolder = new File(workspace);
                            newLocalFolder.deleteOnExit();
                            localFolder = newLocalFolder.getCanonicalPath();
                            System.out.println("[Info] Temporary Workspace Folder: " + localFolder);
                        } else if (localFolder == null || localFolder.isEmpty()) {
                            throw new RuntimeException("[Error] Both the `Workspace` and `Local Workspace Folder` properties must both be set or left empty.");
                        }
                        String username = "PasswordIsAuthToken";
                        String password = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
                        String webUrl = System.getenv("AH_WEB_URL");
                        URI url = new URI(webUrl);
                        VersionClient versionClient = new VersionClient(url, username, password);
                        ComponentClient componentClient = new ComponentClient(url, username, password);
                        client = new TfsSourceClient(exePath, repoUrl, tfsUsername, tfsPassword);
                        if (!client.workspaceExists(workspace)) {
                            client.createWorkspace(workspace);
                            workspaceCreated = true;
                        }
                        client.mapWorkspace(workspace, serverFolder, localFolder);
                        if (label != null && label.length() > 0) {
                            udVersionName = label;
                            System.out.println("Label from TFS: " + udVersionName);
                            client.getLabel(serverFolder, localFolder, true, label);
                        } else if (changeSet != null && changeSet.length() > 0) {
                            udVersionName = changeSet;
                            System.out.println("Changeset from TFS: " + udVersionName);
                            client.getChangeset(serverFolder, localFolder, true, changeSet);
                        } else {
                            udVersionName = client.getLatest(serverFolder, localFolder, true);
                        }
                        List versions = componentClient.getComponentVersions(componentName, Boolean.valueOf(false));
                        boolean hasUdVersion = versions.contains(udVersionName);
                        if (!hasUdVersion) {
                            System.out.println(String.format("Creating Version: %s", udVersionName));
                            String versionId = versionClient.createVersion(componentName, udVersionName, " ").toString();
                            this.outputProperties.setProperty("VersionID", versionId);
                            if (isUseVFS) {
                                System.out.println("Uploading files to VFS");
                                tempDir = new File(localFolder);
                                versionClient.addVersionFiles(componentName, udVersionName, tempDir, "", includes, excludes, saveExecutePermissions, true, charset, extensions);
                            } else {
                                System.out.println("Skipping Artifact Upload: Component is configured not to use codestation.");
                            }
                            break block34;
                        }
                        System.out.println(String.format("Component Already Has Version: %s", udVersionName));
                    }
                    Object var37_38 = null;
                    if (tempDir == null || !tempDir.exists()) break block35;
                    tempDir.delete();
                }
                catch (Throwable throwable) {
                    Exception e222;
                    Object var37_40 = null;
                    if (tempDir != null && tempDir.exists()) {
                        tempDir.delete();
                    }
                    if (workspaceCreated) {
                        try {
                            client.deleteWorkspace(workspace);
                        }
                        catch (Exception e222) {
                            System.err.println("Unable to delete temporary workspace.");
                        }
                    }
                    if (newLocalFolder != null && newLocalFolder.exists()) {
                        try {
                            System.out.println("Deleting Local Workspace Folder: " + newLocalFolder.getCanonicalPath());
                            FileUtils.deleteDirectory((File)newLocalFolder);
                        }
                        catch (Exception e222) {
                            System.err.println("Unable to delete temporary local workspace folder.");
                        }
                    }
                    throw throwable;
                }
            }
            if (workspaceCreated) {
                try {
                    client.deleteWorkspace(workspace);
                }
                catch (Exception e222) {
                    System.err.println("Unable to delete temporary workspace.");
                }
            }
            if (newLocalFolder != null && newLocalFolder.exists()) {
                try {
                    System.out.println("Deleting Local Workspace Folder: " + newLocalFolder.getCanonicalPath());
                    FileUtils.deleteDirectory((File)newLocalFolder);
                }
                catch (Exception e222) {
                    System.err.println("Unable to delete temporary local workspace folder.");
                }
            }
            break block38;
            {
                catch (Exception e3) {
                    Exception e222;
                    e3.printStackTrace();
                    System.err.println(String.format("Error Creating New Version: %s", e3.getMessage()));
                    returnCode = 1;
                    Object var37_39 = null;
                    if (tempDir != null && tempDir.exists()) {
                        tempDir.delete();
                    }
                    if (workspaceCreated) {
                        try {
                            client.deleteWorkspace(workspace);
                        }
                        catch (Exception e222) {
                            System.err.println("Unable to delete temporary workspace.");
                        }
                    }
                    if (newLocalFolder != null && newLocalFolder.exists()) {
                        try {
                            System.out.println("Deleting Local Workspace Folder: " + newLocalFolder.getCanonicalPath());
                            FileUtils.deleteDirectory((File)newLocalFolder);
                        }
                        catch (Exception e222) {
                            System.err.println("Unable to delete temporary local workspace folder.");
                        }
                    }
                }
            }
        }
        return returnCode;
    }
}

