/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.controller;

import com.urbancode.commons.web.controller.DynamicResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ContentDownloadResponse
implements DynamicResponse {
    private static final MimetypesFileTypeMap mimeTypeMap = new MimetypesFileTypeMap();
    private final String contentType;
    private final String fileName;
    private final InputStream content;

    public ContentDownloadResponse(String fileName, byte[] content) {
        this(fileName, new ByteArrayInputStream(content), mimeTypeMap.getContentType(fileName));
    }

    public ContentDownloadResponse(String fileName, InputStream content, String contentType) {
        if (fileName == null) {
            throw new NullPointerException("File Name can not be null");
        }
        if (content == null) {
            throw new NullPointerException("Content can not be null");
        }
        this.fileName = fileName;
        this.content = content;
        this.contentType = contentType;
    }

    public void respond(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType(this.contentType);
        response.setHeader("Pragma", "public");
        response.setHeader("Cache-Control", "max-age=0");
        String header = "attachment; filename=\"" + this.fileName.replaceAll("\"", "\\\\\"") + "\"";
        response.setHeader("Content-disposition", header);
        try {
            int numRead;
            ServletOutputStream os = response.getOutputStream();
            byte[] bytes = new byte[4096];
            while ((numRead = this.content.read(bytes)) >= 0) {
                os.write(bytes, 0, numRead);
            }
            os.flush();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

