/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

public class ThreadBarrier {
    private int currentCount = 0;
    private int requiredCount = 0;
    private long timeout = 0L;

    public ThreadBarrier(int requiredCount) {
        this(requiredCount, 0L);
    }

    public ThreadBarrier(int requiredCount, long timeout) {
        this.requiredCount = requiredCount;
        this.timeout = timeout;
    }

    public synchronized void meet() throws InterruptedException {
        ++this.currentCount;
        if (this.currentCount >= this.requiredCount) {
            this.notifyAll();
            this.reset();
        } else if (this.timeout > 0L) {
            this.wait(this.timeout);
        } else {
            this.wait();
        }
    }

    public synchronized void reset() {
        this.currentCount = 0;
    }
}

