/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.xml;

public class XMLUtils {
    private static final char[] quote = "&quot;".toCharArray();
    private static final char[] amp = "&amp;".toCharArray();
    private static final char[] lt = "&lt;".toCharArray();
    private static final char[] gt = "&gt;".toCharArray();
    private static final char[] empty = new char[0];

    public static String escapeStringAndNull(String raw) {
        if (raw != null) {
            return XMLUtils.escapeString(raw);
        }
        return "(null)";
    }

    public static String escapeString(String raw) {
        return new String(XMLUtils.escapeChars(raw.toCharArray()));
    }

    public static char[] escapeChars(char[] cbuf) {
        return XMLUtils.escapeChars(cbuf, 0, cbuf.length);
    }

    public static char[] escapeChars(char[] cbuf, int off, int len) {
        StringBuffer result = new StringBuffer(cbuf.length);
        for (int i = off; i < cbuf.length && i < off + len; ++i) {
            result.append(XMLUtils.escapeChar(cbuf[i]));
        }
        return result.toString().toCharArray();
    }

    private static char[] escapeChar(char ch) {
        char c = ch;
        if (c == '<') {
            return lt;
        }
        if (c == '>') {
            return gt;
        }
        if (c == '&') {
            return amp;
        }
        if (c == '\"') {
            return quote;
        }
        if (c >= ' ' && c < '\u007f' && c != '\'') {
            return new char[]{ch};
        }
        if (!(!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') && (c < '\u10000' || c > '\u10ffff') || c >= '\u007f' && c <= '\u0084' || c >= '\u0086' && c <= '\u009f' || c >= '\ufdd0' && c <= '\ufddf' || c >= '\u1fffe' && c <= '\u1ffff' || c >= '\u2fffe' && c <= '\u2ffff' || c >= '\u3fffe' && c <= '\u3ffff' || c >= '\u4fffe' && c <= '\u4ffff' || c >= '\u5fffe' && c <= '\u5ffff' || c >= '\u6fffe' && c <= '\u6ffff' || c >= '\u7fffe' && c <= '\u7ffff' || c >= '\u8fffe' && c <= '\u8ffff' || c >= '\u9fffe' && c <= '\u9ffff' || c >= '\uafffe' && c <= '\uaffff' || c >= '\ubfffe' && c <= '\ubffff' || c >= '\ucfffe' && c <= '\ucffff' || c >= '\udfffe' && c <= '\udffff' || c >= '\uefffe' && c <= '\ueffff' || c >= '\uffffe' && c <= '\ufffff' || c >= '\u10fffe' && c <= '\u10ffff')) {
            String cStr = Integer.toHexString(c);
            char[] result = new char[cStr.length() + 4];
            result[0] = 38;
            result[1] = 35;
            result[2] = 120;
            cStr.getChars(0, cStr.length(), result, 3);
            result[result.length - 1] = 59;
            return result;
        }
        return empty;
    }

    private XMLUtils() {
    }
}

