/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.ssl;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.ssl.StoredX509Cert;
import com.urbancode.commons.util.ssl.X509CertStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class StoringX509TrustManager
implements X509TrustManager {
    private static final Logger log = Logger.getLogger(StoringX509TrustManager.class);
    private final X509TrustManager delegate;
    private final X509CertStore certStore;

    public static TrustManager[] wrap(TrustManager[] managers, X509CertStore certStore) {
        if (managers != null) {
            for (int i = 0; i < managers.length; ++i) {
                TrustManager manager = managers[i];
                if (!(manager instanceof X509TrustManager)) continue;
                X509TrustManager x509Manager = (X509TrustManager)manager;
                x509Manager = new StoringX509TrustManager(x509Manager, certStore);
                managers[i] = x509Manager;
            }
        }
        return managers;
    }

    public StoringX509TrustManager(X509TrustManager delegate, X509CertStore certStore) {
        this.delegate = Check.nonNull(delegate, "delegate");
        this.certStore = certStore;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        StoredX509Cert storedCert = new StoredX509Cert(chain, authType);
        try {
            this.delegate.checkClientTrusted(chain, authType);
            this.certStore.store(storedCert, true);
        }
        catch (CertificateException e) {
            try {
                this.certStore.store(storedCert, false);
            }
            catch (Exception storeException) {
                log.warn("Error storing client certificate that is not trusted.", e);
            }
            throw e;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] issuers = this.delegate.getAcceptedIssuers();
        return issuers;
    }
}

