/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.unix;

public class UMask {
    private static final UMask globalInstance = UMask.createFromSystem();
    private static final int MASK = 4095;
    private static final String DEFAULT_UMASK = "0022";
    private static final String UMASK_KEY = "com.urbancode.process.unix.umask";
    private volatile int value;

    public static UMask getGlobalInstance() {
        return globalInstance;
    }

    public static UMask create(int mode) {
        return new UMask(mode);
    }

    public static UMask createFromSystem() {
        int umask;
        try {
            umask = Integer.parseInt(System.getProperty(UMASK_KEY, DEFAULT_UMASK), 8);
        }
        catch (NumberFormatException e) {
            umask = Integer.parseInt(DEFAULT_UMASK, 8);
        }
        return UMask.create(umask);
    }

    public static UMask createFromGlobalInstance() {
        return UMask.getGlobalInstance().copy();
    }

    private UMask(int value) {
        this.value = value & 0xFFF;
    }

    public UMask copy() {
        return new UMask(this.value);
    }

    public int get() {
        return this.value;
    }

    public void set(int value) {
        this.value = value & 0xFFF;
    }

    public int getMode(int mode) {
        return mode & ~this.get() & 0xFFF;
    }
}

