/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.externalsort;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.externalsort.Partition;
import com.urbancode.commons.util.externalsort.RecordIOFactory;
import com.urbancode.commons.util.externalsort.RecordReader;
import com.urbancode.commons.util.externalsort.RecordWriter;
import com.urbancode.commons.util.externalsort.TempFileFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.log4j.Logger;

final class SortOperation<T> {
    private static final Logger log = Logger.getLogger(SortOperation.class);
    private final RecordIOFactory<T> factory;
    private final int maxRecordsInMemory;
    private final int maxOpenFiles;
    private final Comparator<? super T> comparator;
    private final File source;
    private final File destination;
    private final TempFileFactory tempFileFactory;
    private ArrayList<File> sectionFiles = new ArrayList();
    private ArrayList<Partition<T>> partitions = new ArrayList();

    SortOperation(RecordIOFactory<T> factory, int maxRecordsInMemory, int maxOpenFiles, File tempDirectory, Comparator<? super T> comparator, File source, File destination) {
        if (maxRecordsInMemory < 2) {
            throw new IllegalArgumentException();
        }
        if (maxOpenFiles < 2) {
            throw new IllegalArgumentException();
        }
        this.factory = Check.nonNull(factory, "factory");
        this.maxRecordsInMemory = maxRecordsInMemory;
        this.maxOpenFiles = maxOpenFiles;
        this.comparator = Check.nonNull(comparator, "comparator");
        this.source = Check.nonNull(source, "source");
        this.destination = Check.nonNull(destination, "destination");
        Check.nonNull(tempDirectory, "tempDirectory");
        this.tempFileFactory = new TempFileFactory(tempDirectory);
    }

    void doSort() throws IOException {
        try {
            this.split();
            File mergeResult = this.sectionFiles.isEmpty() ? this.source : this.merge();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Moving merge result " + mergeResult + " to destination " + this.destination));
            }
            IO.move(mergeResult, this.destination);
        }
        finally {
            for (File file : this.sectionFiles) {
                file.delete();
            }
            for (Partition partition : this.partitions) {
                partition.deleteFiles();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void split() throws IOException {
        long recordCount = 0L;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Splitting " + this.source));
        }
        RecordReader<T> sourceReader = this.factory.newReader(IO.openInput(this.source));
        try {
            block6: while (true) {
                T record;
                int count;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Reading up to " + this.maxRecordsInMemory + " records into memory"));
                }
                Object[] currentSection = new Object[this.maxRecordsInMemory];
                for (count = 0; count < currentSection.length && (record = sourceReader.read()) != null; ++count) {
                    ++recordCount;
                    currentSection[count] = record;
                }
                if (count == 0) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sorting " + count + " records in memory"));
                }
                Arrays.sort(currentSection, 0, count, this.comparator);
                File sectionFile = this.tempFileFactory.newTemporaryFile();
                this.sectionFiles.add(sectionFile);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Writing " + count + " record section to " + sectionFile));
                }
                RecordWriter<Object> writer = this.factory.newWriter(IO.openOutput(sectionFile));
                try {
                    int i = 0;
                    while (true) {
                        if (i >= count) continue block6;
                        writer.write(currentSection[i]);
                        ++i;
                    }
                }
                finally {
                    writer.close();
                    continue;
                }
                break;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Split complete: " + recordCount + " records into " + this.sectionFiles.size() + " sections"));
            }
        }
        finally {
            sourceReader.close();
        }
    }

    private File merge() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Merging " + this.sectionFiles.size() + " sections"));
        }
        this.partitions = this.partition(this.sectionFiles);
        this.sectionFiles.clear();
        while (this.partitions.size() > 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Merging " + this.partitions.size() + " partitions"));
            }
            for (Partition<T> partition : this.partitions) {
                File partitionFile = this.tempFileFactory.newTemporaryFile();
                partition.mergeTo(partitionFile);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Partition merged");
                }
                this.sectionFiles.add(partitionFile);
                partition.deleteFiles();
            }
            this.partitions = this.partition(this.sectionFiles);
            this.sectionFiles.clear();
        }
        File finalFile = this.tempFileFactory.newTemporaryFile();
        Partition<T> finalPartition = this.partitions.get(0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Merging final partition to " + finalFile));
        }
        finalPartition.mergeToAndSync(finalFile);
        finalPartition.deleteFiles();
        this.partitions.clear();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Merging complete");
        }
        return finalFile;
    }

    private ArrayList<Partition<T>> partition(ArrayList<File> sections) {
        ArrayList<Partition<T>> partitions = new ArrayList<Partition<T>>();
        int partitionSize = this.maxOpenFiles - 1;
        for (int start = 0; start < sections.size(); start += partitionSize) {
            int end = Math.min(sections.size(), start + partitionSize);
            ArrayList<File> partitionFiles = new ArrayList<File>(sections.subList(start, end));
            partitions.add(new Partition<T>(this.maxRecordsInMemory, this.factory, this.comparator, partitionFiles));
        }
        return partitions;
    }
}

