/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.securedata;

import com.urbancode.air.securedata.BadEnvelopeException;
import com.urbancode.air.securedata.Envelope;
import com.urbancode.air.securedata.Keys;
import com.urbancode.air.securedata.SecretContainer;
import com.urbancode.air.securedata.crypto.CipherAlgorithm;
import com.urbancode.air.securedata.crypto.CryptoSuite;
import com.urbancode.air.securedata.crypto.MACAlgorithm;
import com.urbancode.commons.util.crypto.SecureEquals;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

class EnvelopeDecoder {
    private final SecretContainer secret;
    private final CryptoSuite suite;
    private final long maxTimestampSkew;

    EnvelopeDecoder(SecretContainer secret, CryptoSuite suite, long maxTimestampSkew) {
        secret.getClass();
        suite.getClass();
        this.secret = secret;
        this.suite = suite;
        this.maxTimestampSkew = maxTimestampSkew;
    }

    void decodeBody(Envelope envelope) throws GeneralSecurityException {
        envelope.getClass();
        CipherAlgorithm cipherAlgorithm = this.suite.getCipherAlgorithm();
        MACAlgorithm macAlgorithm = this.suite.getMACAlgorithm();
        Keys keys = new Keys(this.secret, envelope.getHeader().getInitializationVector(), envelope.getHeader().getTimestamp(), this.suite);
        SecretKey hmacKey = keys.getMACKey();
        Mac mac = macAlgorithm.createMac();
        mac.init(hmacKey);
        mac.update(envelope.getHeader().toBytesForMAC());
        byte[] computeHmac = mac.doFinal(envelope.getBody());
        if (!SecureEquals.secureEquals((byte[])computeHmac, (byte[])envelope.getHMAC())) {
            throw new BadEnvelopeException("bad HMAC: message has been damaged or tampered with");
        }
        if (this.maxTimestampSkew > 0L) {
            long timestamp = envelope.getHeader().getTimestamp();
            long now = System.currentTimeMillis();
            long hi = now + this.maxTimestampSkew;
            long lo = now - this.maxTimestampSkew;
            if (timestamp < lo || timestamp > hi) {
                throw new BadEnvelopeException(String.format("clock skew: message timestamp outside acceptable range: hi=%d lo=%d timestamp=%d", hi, lo, timestamp));
            }
        }
        SecretKey encryptionKey = keys.getCipherKey();
        Cipher cipher = cipherAlgorithm.createCipher(encryptionKey, envelope.getHeader().getInitializationVector(), 2);
        envelope.setBody(cipher.doFinal(envelope.getBody()));
    }
}

