/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.securedata;

import com.urbancode.air.securedata.Base64Codec;
import com.urbancode.commons.util.IO;
import java.security.Key;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Formatter;

public class FingerPrinter {
    private final F formatter;
    private final D digester;

    public static FingerPrinter hexMD5() {
        return new FingerPrinter(F.HEX, D.MD5);
    }

    public static FingerPrinter hexSHA1() {
        return new FingerPrinter(F.HEX, D.SHA1);
    }

    public static FingerPrinter hexSHA256() {
        return new FingerPrinter(F.HEX, D.SHA256);
    }

    public static FingerPrinter base64MD5() {
        return new FingerPrinter(F.BASE64, D.MD5);
    }

    public static FingerPrinter base64SHA1() {
        return new FingerPrinter(F.BASE64, D.SHA1);
    }

    public static FingerPrinter base64SHA256() {
        return new FingerPrinter(F.BASE64, D.SHA256);
    }

    FingerPrinter(F formatter, D digester) {
        ((Object)((Object)formatter)).getClass();
        ((Object)((Object)digester)).getClass();
        this.formatter = formatter;
        this.digester = digester;
    }

    public String fingerprint(Key key) {
        return this.formatter.format(this.digester.digest(key.getEncoded()));
    }

    public String fingerprint(Certificate cert) throws CertificateEncodingException {
        return this.formatter.format(this.digester.digest(cert.getEncoded()));
    }

    public String fingerprint(byte[] bytes) {
        bytes.getClass();
        return this.formatter.format(this.digester.digest(bytes));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum F {
        HEX{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            String format(byte[] bytes) {
                Formatter fmt = new Formatter();
                try {
                    fmt.format("%02X", bytes[0] & 0xFF);
                    for (int i = 1; i < bytes.length; ++i) {
                        fmt.format(":%02X", bytes[i] & 0xFF);
                    }
                    String string = fmt.toString();
                    return string;
                }
                finally {
                    fmt.close();
                }
            }
        }
        ,
        BASE64{

            String format(byte[] bytes) {
                return new Base64Codec().encodeToString(bytes);
            }
        };


        abstract String format(byte[] var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum D {
        MD5{

            MessageDigest digester() {
                return IO.md5Digester();
            }
        }
        ,
        SHA1{

            MessageDigest digester() {
                return IO.sha1Digester();
            }
        }
        ,
        SHA256{

            MessageDigest digester() {
                return IO.sha256Digester();
            }
        };


        byte[] digest(byte[] bytes) {
            return this.digester().digest(bytes);
        }

        abstract MessageDigest digester();
    }
}

