/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.tags;

import com.urbancode.commons.web.util.DateFormatter;
import java.io.IOException;
import java.util.Date;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.taglibs.standard.tag.rt.fmt.FormatDateTag;

public class DateFormatterTag
extends FormatDateTag {
    private static final long serialVersionUID = 3303219980443313177L;
    private Date value;
    private String type;
    private String dateStyle;
    private String timeStyle;
    private String pattern;
    private Object timeZone;
    private String customFormat;

    public DateFormatterTag() {
        this.init();
    }

    public int doStartTag() throws JspException {
        if (this.customFormat != null) {
            try {
                String result = null;
                JspWriter writer = this.pageContext.getOut();
                Type type = Type.valueOf(this.customFormat);
                switch (type) {
                    case date: {
                        result = DateFormatter.formatDate((Date)this.value);
                        writer.print(result);
                        break;
                    }
                    case date_with_time: {
                        result = DateFormatter.formatDateWithTime((Date)this.value, (String)((String)this.timeZone));
                        writer.print(result);
                        break;
                    }
                    case date_with_time_special: {
                        result = DateFormatter.formatDateWithTime((Date)this.value, (String)((String)this.timeZone), (int)7);
                        writer.print(result);
                        break;
                    }
                    case relative: {
                        result = DateFormatter.formatRelativeTime((Date)this.value);
                        writer.print(result);
                        break;
                    }
                    case relative_fine: {
                        result = DateFormatter.formatRelativeFineTime((Date)this.value);
                        writer.print(result);
                        break;
                    }
                }
            }
            catch (IOException e) {
                throw new JspException("Error: " + e.getMessage(), (Throwable)e);
            }
            return 0;
        }
        super.setValue(this.value);
        super.setType(this.type);
        super.setDateStyle(this.dateStyle);
        super.setTimeStyle(this.timeStyle);
        super.setPattern(this.pattern);
        super.setTimeZone(this.timeZone);
        return super.doStartTag();
    }

    public void release() {
        super.release();
        this.init();
    }

    public void setValue(Date value) {
        this.value = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDateStyle(String dateStyle) {
        this.dateStyle = dateStyle;
    }

    public void setTimeStyle(String timeStyle) {
        this.timeStyle = timeStyle;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setTimeZone(Object timeZone) {
        this.timeZone = timeZone;
    }

    public void setCustomFormat(String customFormat) {
        this.customFormat = customFormat;
    }

    public String getCustomFormat() {
        return this.customFormat;
    }

    private void init() {
        this.value = null;
        this.type = null;
        this.dateStyle = null;
        this.timeStyle = null;
        this.pattern = null;
        this.timeZone = null;
        this.customFormat = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        date,
        date_with_time,
        date_with_time_special,
        relative,
        relative_fine;

    }
}

