/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ud.client;

import com.urbancode.ud.client.UDRestClient;
import java.io.IOException;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.impl.client.DefaultHttpClient;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ProcessClient
extends UDRestClient {
    public ProcessClient(URI url, String clientUser, String clientPassword) {
        super(url, clientUser, clientPassword);
    }

    public ProcessClient(URI url, String clientUser, String clientPassword, boolean trustAllCerts) {
        super(url, clientUser, clientPassword, trustAllCerts);
    }

    public ProcessClient(URI url, DefaultHttpClient client) {
        super(url, client);
    }

    public String getGenericProcessResult(String processID, int timeoutInMinutes) throws IOException, JSONException, InterruptedException, RemoteException {
        String result = "";
        String workflowTraceID = this.getWorkflowTraceID(processID);
        String uri = this.url + "/rest/workflow/workflowTrace/" + this.encodePath(workflowTraceID);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        long pollInterval = 1000L;
        long timeoutInterval = (long)timeoutInMinutes * 60L * 1000L;
        long start = System.currentTimeMillis();
        boolean found = false;
        while (!found) {
            if (System.currentTimeMillis() - start > timeoutInterval) {
                throw new RemoteException("Timeout waiting for generic process to finish");
            }
            this.discardBody(response);
            Thread.sleep(pollInterval);
            method = new HttpGet(uri);
            response = this.invokeMethod(method);
            String body = this.getBody(response);
            JSONObject jsonResult = new JSONObject(body);
            JSONObject rootActivity = (JSONObject)jsonResult.get("rootActivity");
            String workflowStatus = (String)rootActivity.get("state");
            if (!workflowStatus.equalsIgnoreCase("CLOSED") && !workflowStatus.equalsIgnoreCase("COMPLETED")) continue;
            result = (String)jsonResult.get("result");
            found = true;
        }
        return result;
    }

    public JSONArray getProcessRequestProperties(String processId) throws IOException, JSONException {
        String uri = this.url + "/rest/process/request/" + this.encodePath(processId) + "/properties";
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        JSONArray result = new JSONArray(this.getBody(response));
        return result;
    }

    public String getWorkflowTraceID(String processID) throws IOException, JSONException {
        String uri = this.url + "/rest/process/request/" + this.encodePath(processID);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONObject jsonResult = new JSONObject(body);
        String result = (String)jsonResult.get("workflowTraceId");
        return result;
    }

    public UUID requestGenericProcess(String processId, String processVersion, String resource, Properties properties) throws IOException, JSONException {
        JSONObject jsonToSend = new JSONObject();
        jsonToSend.put("processId", processId);
        if (processVersion != null) {
            jsonToSend.put("processVersion", processVersion);
        }
        JSONObject propsJson = new JSONObject();
        if (properties != null) {
            for (String propName : properties.stringPropertyNames()) {
                propsJson.put(propName, properties.getProperty(propName));
            }
        }
        jsonToSend.put("resource", resource);
        jsonToSend.put("properties", propsJson);
        String uri = this.url + "/rest/process/request";
        HttpPost method = new HttpPost(uri);
        method.setEntity(this.getStringEntity(jsonToSend));
        CloseableHttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONObject jsonResult = new JSONObject(body);
        UUID result = UUID.fromString((String)jsonResult.get("id"));
        return result;
    }

    public void setProcessRequestProperty(String processId, String name, String value, boolean isSecure) throws IOException, JSONException {
        if (StringUtils.isEmpty(processId)) {
            throw new IOException("processId was not supplied");
        }
        if (StringUtils.isEmpty(name)) {
            throw new IOException("name was not supplied");
        }
        String uri = this.url + "/rest/process/request/" + this.encodePath(processId) + "/saveProperties";
        JSONArray props = new JSONArray();
        props.put(this.createNewPropertyJSON(name, value, isSecure));
        HttpPut method = new HttpPut(uri);
        method.setEntity(this.getStringEntity(props));
        this.invokeMethod(method);
    }
}

