/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.event;

import com.urbancode.commons.fileutils.FileUtils;
import com.urbancode.commons.fileutils.event.FileEvent;
import com.urbancode.commons.fileutils.event.FileListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FileObserver {
    private File observed;
    private boolean isDirectory;
    private Map observedMap = new HashMap();
    private FileFilter filter;
    private List listeners = new ArrayList();

    public FileObserver(File observed) {
        this(observed, null);
    }

    public FileObserver(File observed, FileFilter filter) {
        this.observed = observed;
        this.filter = filter;
        if (observed == null) {
            throw new IllegalArgumentException("Observed file can not be null.");
        }
        if (!observed.exists()) {
            throw new IllegalArgumentException("Observed file must exist.");
        }
        this.isDirectory = observed.isDirectory();
    }

    public void run() {
        if (this.isDirectory) {
            ArrayList<String> shouldBeObservedFiles = new ArrayList<String>();
            Iterator fileItr = FileUtils.getDirectoryFilesAndDirectories(this.observed);
            while (fileItr.hasNext()) {
                File file = (File)fileItr.next();
                boolean addIt = true;
                if (this.filter != null) {
                    addIt = this.filter.accept(file);
                }
                if (!addIt) continue;
                shouldBeObservedFiles.add(FileUtils.getNormalizedName(file));
            }
            ArrayList observedFileList = new ArrayList();
            observedFileList.addAll(this.observedMap.keySet());
            for (String observedName : observedFileList) {
                if (shouldBeObservedFiles.contains(observedName)) continue;
                File removedFile = new File(observedName);
                this.removeObservedFile(removedFile);
            }
            for (String shouldBeObservedName : shouldBeObservedFiles) {
                File shouldBeObservedFile = new File(shouldBeObservedName);
                if (this.isObserved(shouldBeObservedFile)) {
                    Long lastModified = this.getLastModified(shouldBeObservedFile);
                    if (shouldBeObservedFile.lastModified() <= lastModified) continue;
                    this.observedFileModified(shouldBeObservedFile);
                    continue;
                }
                File addFile = new File(shouldBeObservedName);
                this.addObservedFile(addFile);
            }
        } else if (this.observed.exists()) {
            if (this.isObserved(this.observed)) {
                Long lastModified = this.getLastModified(this.observed);
                if (this.observed.lastModified() > lastModified) {
                    this.observedFileModified(this.observed);
                }
            } else {
                this.addObservedFile(this.observed);
            }
        } else if (this.isObserved(this.observed)) {
            this.removeObservedFile(this.observed);
        }
    }

    private boolean isObserved(File file) {
        String observedName = FileUtils.getNormalizedName(file);
        return this.observedMap.get(observedName) != null;
    }

    private Long getLastModified(File file) {
        String observedName = FileUtils.getNormalizedName(file);
        return (Long)this.observedMap.get(observedName);
    }

    private void addObservedFile(File file) {
        String observedName = FileUtils.getNormalizedName(file);
        this.observedMap.put(observedName, new Long(file.lastModified()));
        this.fireFileAddedEvent(file);
    }

    private void removeObservedFile(File file) {
        String observedName = FileUtils.getNormalizedName(file);
        this.observedMap.remove(observedName);
        this.fireFileRemovedEvent(file);
    }

    private void observedFileModified(File file) {
        String observedName = FileUtils.getNormalizedName(file);
        this.observedMap.put(observedName, new Long(file.lastModified()));
        this.fireFileModifiedEvent(file);
    }

    public void addFileListener(FileListener listener) {
        this.listeners.add(listener);
    }

    public void removeFileListener(FileListener listener) {
        this.listeners.remove(listener);
    }

    private void fireFileAddedEvent(File file) {
        FileEvent event = new FileEvent(file);
        for (FileListener listener : this.listeners) {
            listener.fileAdded(event);
        }
    }

    private void fireFileModifiedEvent(File file) {
        FileEvent event = new FileEvent(file);
        for (FileListener listener : this.listeners) {
            listener.fileModified(event);
        }
    }

    private void fireFileRemovedEvent(File file) {
        FileEvent event = new FileEvent(file);
        for (FileListener listener : this.listeners) {
            listener.fileRemoved(event);
        }
    }
}

